/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.api.connection;

import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.api.WireProtocol;
import org.apache.dubbo.remoting.transport.AbstractClient;

public abstract class AbstractConnectionClient
extends AbstractClient {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(AbstractConnectionClient.class);
    protected WireProtocol protocol;
    protected InetSocketAddress remote;
    protected AtomicBoolean init;
    protected static final Object CONNECTED_OBJECT = new Object();
    private volatile long counter;
    private static final AtomicLongFieldUpdater<AbstractConnectionClient> COUNTER_UPDATER = AtomicLongFieldUpdater.newUpdater(AbstractConnectionClient.class, "counter");

    protected AbstractConnectionClient(URL url, ChannelHandler handler) throws RemotingException {
        super(url, handler);
    }

    public final void increase() {
        COUNTER_UPDATER.set(this, 1L);
    }

    public final AbstractConnectionClient retain() {
        long oldCount = COUNTER_UPDATER.getAndIncrement(this);
        if (oldCount <= 0L) {
            COUNTER_UPDATER.getAndDecrement(this);
            throw new AssertionError((Object)"This instance has been destroyed");
        }
        return this;
    }

    public final boolean release() {
        long remainingCount = COUNTER_UPDATER.decrementAndGet(this);
        if (remainingCount == 0L) {
            this.destroy();
            return true;
        }
        if (remainingCount <= -1L) {
            logger.warn("4-7", "", "", "This instance has been destroyed");
            return false;
        }
        return false;
    }

    protected abstract void initConnectionClient();

    public abstract boolean isAvailable();

    public abstract void createConnectingPromise();

    public abstract void addCloseListener(Runnable var1);

    public abstract void onConnected(Object var1);

    public abstract void onGoaway(Object var1);

    public abstract void destroy();

    public abstract Object getChannel(Boolean var1);

    public long getCounter() {
        return COUNTER_UPDATER.get(this);
    }
}

