/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common.compiler.support;

import org.apache.dubbo.common.compiler.Compiler;
import org.apache.dubbo.common.extension.Adaptive;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.rpc.model.FrameworkModel;
import org.apache.dubbo.rpc.model.ScopeModelAware;

@Adaptive
public class AdaptiveCompiler
implements Compiler,
ScopeModelAware {
    private FrameworkModel frameworkModel;
    private static volatile String DEFAULT_COMPILER;

    @Override
    public void setFrameworkModel(FrameworkModel frameworkModel) {
        this.frameworkModel = frameworkModel;
    }

    public static void setDefaultCompiler(String compiler) {
        DEFAULT_COMPILER = compiler;
    }

    @Override
    public Class<?> compile(Class<?> neighbor, String code, ClassLoader classLoader) {
        ExtensionLoader<Compiler> loader = this.frameworkModel.getExtensionLoader(Compiler.class);
        String name = DEFAULT_COMPILER;
        Compiler compiler = name != null && name.length() > 0 ? loader.getExtension(name) : loader.getDefaultExtension();
        return compiler.compile(neighbor, code, classLoader);
    }
}

