/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.common;

import java.util.Objects;
import org.apache.dubbo.common.ServiceKey;
import org.apache.dubbo.common.utils.StringUtils;

public class ProtocolServiceKey
extends ServiceKey {
    private final String protocol;

    public ProtocolServiceKey(String interfaceName, String version, String group, String protocol) {
        super(interfaceName, version, group);
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getServiceKeyString() {
        return super.toString();
    }

    public boolean isSameWith(ProtocolServiceKey protocolServiceKey) {
        if (!super.equals(protocolServiceKey)) {
            return false;
        }
        if ("*".equals(this.protocol)) {
            return false;
        }
        if (StringUtils.isEmpty(this.protocol) || StringUtils.isEmpty(protocolServiceKey.getProtocol())) {
            return true;
        }
        return Objects.equals(this.protocol, protocolServiceKey.getProtocol());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProtocolServiceKey that = (ProtocolServiceKey)o;
        return Objects.equals(this.protocol, that.protocol);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.protocol);
    }

    @Override
    public String toString() {
        return super.toString() + ":" + this.protocol;
    }

    public static class Matcher {
        public static boolean isMatch(ProtocolServiceKey rule, ProtocolServiceKey target) {
            if (!ServiceKey.Matcher.isMatch(rule, target)) {
                return false;
            }
            if (!"*".equals(rule.getProtocol()) && StringUtils.isNotEmpty(rule.getProtocol())) {
                if (rule.getProtocol().contains(",")) {
                    String[] protocols = rule.getProtocol().split("\\,", -1);
                    boolean match = false;
                    for (String protocol : protocols) {
                        if (StringUtils.isEmpty(protocol = protocol.trim()) && StringUtils.isEmpty(target.getProtocol())) {
                            match = true;
                            break;
                        }
                        if (!protocol.equals(target.getProtocol())) continue;
                        match = true;
                        break;
                    }
                    if (!match) {
                        return false;
                    }
                } else if (!Objects.equals(rule.getProtocol(), target.getProtocol())) {
                    return false;
                }
            }
            return true;
        }
    }
}

