/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting;

import com.alipay.remoting.Connection;
import com.alipay.remoting.ConnectionEventProcessor;
import com.alipay.remoting.ConnectionEventType;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class ConnectionEventListener {
    private ConcurrentHashMap<ConnectionEventType, List<ConnectionEventProcessor>> processors = new ConcurrentHashMap(3);

    public void onEvent(ConnectionEventType type, String remoteAddress, Connection connection) {
        List<ConnectionEventProcessor> processorList = this.processors.get((Object)type);
        if (processorList != null) {
            for (ConnectionEventProcessor processor : processorList) {
                processor.onEvent(remoteAddress, connection);
            }
        }
    }

    public void addConnectionEventProcessor(ConnectionEventType type, ConnectionEventProcessor processor) {
        List<ConnectionEventProcessor> processorList = this.processors.get((Object)type);
        if (processorList == null) {
            this.processors.putIfAbsent(type, new CopyOnWriteArrayList());
            processorList = this.processors.get((Object)type);
        }
        processorList.add(processor);
    }
}

