/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.configs;

import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.SelectorDTO;
import org.apache.shenyu.admin.model.result.ConfigImportResult;
import org.apache.shenyu.admin.model.vo.SelectorVO;
import org.apache.shenyu.admin.service.SelectorService;
import org.apache.shenyu.admin.service.configs.ConfigsExportImportEnum;
import org.apache.shenyu.admin.service.configs.ConfigsExportImportHandler;
import org.apache.shenyu.admin.service.configs.ConfigsImportContext;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.JsonUtils;
import org.springframework.stereotype.Component;

@Component
public class SelectorDataConfigsExportImportHandler
implements ConfigsExportImportHandler {
    private final SelectorService selectorService;

    public SelectorDataConfigsExportImportHandler(SelectorService selectorService) {
        this.selectorService = selectorService;
    }

    @Override
    public ConfigsExportImportEnum configsEnum() {
        return ConfigsExportImportEnum.Selector;
    }

    @Override
    public Optional<String> configsExport(String namespaceId) {
        List<SelectorVO> selectorDataList = this.selectorService.listAllDataByNamespaceId(namespaceId);
        if (CollectionUtils.isNotEmpty(selectorDataList)) {
            selectorDataList.forEach(selectorVO -> selectorVO.setNamespaceId(null));
            return Optional.of(JsonUtils.toJson(selectorDataList));
        }
        return Optional.empty();
    }

    @Override
    public void configsImport(String namespaceId, String data, ConfigsImportContext context) {
        List selectorList = GsonUtils.getInstance().fromList(data, SelectorDTO.class);
        ConfigImportResult configImportResult = this.selectorService.importData(namespaceId, selectorList, context);
        context.getResult().put("selectorImportSuccessCount", configImportResult.getSuccessCount());
        if (StringUtils.isNotEmpty((CharSequence)configImportResult.getFailMessage())) {
            context.getResult().put("selectorImportFailMessage", configImportResult.getFailMessage());
        }
    }
}

