/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.configs;

import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.NamespacePluginDTO;
import org.apache.shenyu.admin.model.result.ConfigImportResult;
import org.apache.shenyu.admin.model.vo.NamespacePluginVO;
import org.apache.shenyu.admin.service.NamespacePluginService;
import org.apache.shenyu.admin.service.configs.ConfigsExportImportEnum;
import org.apache.shenyu.admin.service.configs.ConfigsExportImportHandler;
import org.apache.shenyu.admin.service.configs.ConfigsImportContext;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.JsonUtils;
import org.springframework.stereotype.Component;

@Component
public class NamespacePluginDataConfigsExportImportHandler
implements ConfigsExportImportHandler {
    private final NamespacePluginService namespacePluginService;

    public NamespacePluginDataConfigsExportImportHandler(NamespacePluginService namespacePluginService) {
        this.namespacePluginService = namespacePluginService;
    }

    @Override
    public ConfigsExportImportEnum configsEnum() {
        return ConfigsExportImportEnum.NamespacePlugin;
    }

    @Override
    public Optional<String> configsExport(String namespaceId) {
        List<NamespacePluginVO> namespacePluginVOList = this.namespacePluginService.listAllData(namespaceId);
        if (CollectionUtils.isNotEmpty(namespacePluginVOList)) {
            namespacePluginVOList.forEach(plugin -> plugin.setNamespaceId(null));
            return Optional.of(JsonUtils.toJson(namespacePluginVOList));
        }
        return Optional.empty();
    }

    @Override
    public void configsImport(String namespaceId, String data, ConfigsImportContext context) {
        List pluginList = GsonUtils.getInstance().fromList(data, NamespacePluginDTO.class);
        ConfigImportResult configImportResult = this.namespacePluginService.importData(namespaceId, pluginList, context);
        context.getResult().put("namespacePluginImportSuccessCount", configImportResult.getSuccessCount());
        if (StringUtils.isNotEmpty((CharSequence)configImportResult.getFailMessage())) {
            context.getResult().put("pluginHandleImportFailMessage", configImportResult.getFailMessage());
        }
    }
}

