/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.scale.monitor.subject.cache;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.shenyu.admin.model.entity.ScaleRuleDO;
import org.springframework.stereotype.Component;

@Component
public class ScaleRuleCache {
    private final ConcurrentHashMap<String, ScaleRuleDO> ruleCache = new ConcurrentHashMap();

    public void initialize(List<ScaleRuleDO> rules) {
        this.ruleCache.clear();
        rules.forEach(rule -> this.ruleCache.put(rule.getMetricName(), (ScaleRuleDO)rule));
    }

    public void addOrUpdateRuleToCache(ScaleRuleDO rule) {
        this.ruleCache.put(rule.getMetricName(), rule);
    }

    public void removeRulesFromCache(List<String> metricNames) {
        metricNames.forEach(this.ruleCache::remove);
    }

    public List<ScaleRuleDO> getAllRules() {
        return this.ruleCache.values().stream().toList();
    }

    public ScaleRuleDO getRuleByMetricName(String metricName) {
        return this.ruleCache.get(metricName);
    }
}

