/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.mybatis.oracle;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.util.Properties;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class OracleSQLPrepareInterceptor
implements Interceptor {
    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        BoundSql boundSql = statementHandler.getBoundSql();
        Field field = boundSql.getClass().getDeclaredField("sql");
        field.setAccessible(true);
        String replaceSql = boundSql.getSql().toLowerCase().replace("`desc`", "\"desc\"").replace("true", "'true'");
        replaceSql = replaceSql.replace("`", "");
        if (replaceSql.contains("resource")) {
            replaceSql = replaceSql.replace("into resource", "into \"resource\"").replace("from resource", "from \"resource\"").replace("update resource", "update \"resource\"");
        }
        if (replaceSql.contains("insert into") && replaceSql.split("\\(").length > 3) {
            replaceSql = replaceSql.replaceAll("\r|\n|\\s", "").replace("insertinto", "insert into ").replace("values", " SELECT * FROM (").replace("(?", " SELECT ?").replace("),", " FROM dual UNION ALL").replace("?)", " ? FROM dual)");
        }
        if (replaceSql.contains("select")) {
            replaceSql = replaceSql.contains("where") ? replaceSql.replace("limit 1", "and rownum = 1") : replaceSql.replace("limit 1", "where rownum = 1");
        }
        field.set(boundSql, replaceSql);
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

