/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.entity;

import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.model.dto.PluginDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.vo.NamespacePluginVO;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.apache.shiro.codec.Base64;

public final class PluginDO
extends BaseDO {
    private static final long serialVersionUID = -3414676617520629553L;
    private String name;
    private String config;
    private Boolean enabled;
    private String role;
    private Integer sort;
    private byte[] pluginJar;

    public PluginDO() {
    }

    public PluginDO(String name, String config, Boolean enabled, String role, Integer sort, byte[] pluginJar) {
        this.name = name;
        this.config = config;
        this.enabled = enabled;
        this.role = role;
        this.sort = sort;
        this.pluginJar = pluginJar;
    }

    public byte[] getPluginJar() {
        return this.pluginJar;
    }

    public void setPluginJar(byte[] pluginJar) {
        this.pluginJar = pluginJar;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public Integer getSort() {
        return this.sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public static PluginDOBuilder builder() {
        return new PluginDOBuilder();
    }

    public static PluginDO buildPluginDO(PluginDTO pluginDTO) {
        return Optional.ofNullable(pluginDTO).map(item -> {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            PluginDO pluginDO = PluginDO.builder().name(item.getName()).config(item.getConfig()).enabled(item.getEnabled()).role(item.getRole()).sort(item.getSort()).dateUpdated(currentTime).build();
            if (StringUtils.isEmpty((CharSequence)item.getId())) {
                pluginDO.setId(UUIDUtils.getInstance().generateShortUuid());
                pluginDO.setDateCreated(currentTime);
            } else {
                pluginDO.setId(item.getId());
            }
            if (Objects.nonNull(item.getFile())) {
                pluginDO.setPluginJar(Base64.decode((String)item.getFile()));
            }
            return pluginDO;
        }).orElse(null);
    }

    public static PluginDO buildPluginDO(NamespacePluginVO namespacePluginVO) {
        return Optional.ofNullable(namespacePluginVO).map(item -> {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            PluginDO pluginDO = PluginDO.builder().name(item.getName()).config(item.getConfig()).enabled(item.getEnabled()).role(item.getRole()).sort(item.getSort()).dateUpdated(currentTime).build();
            if (StringUtils.isEmpty((CharSequence)item.getId())) {
                pluginDO.setId(UUIDUtils.getInstance().generateShortUuid());
                pluginDO.setDateCreated(currentTime);
            } else {
                pluginDO.setId(item.getPluginId());
            }
            if (Objects.nonNull(item.getFile())) {
                pluginDO.setPluginJar(Base64.decode((String)item.getFile()));
            }
            return pluginDO;
        }).orElse(null);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (Objects.isNull(o) || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PluginDO pluginDO = (PluginDO)o;
        return Objects.equals(this.name, pluginDO.name) && Objects.equals(this.config, pluginDO.config) && Objects.equals(this.enabled, pluginDO.enabled) && Objects.equals(this.role, pluginDO.role) && Objects.equals(this.sort, pluginDO.sort) && Arrays.equals(this.pluginJar, pluginDO.pluginJar);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.name, this.config, this.enabled, this.role, this.sort);
    }

    public static final class PluginDOBuilder {
        private String id;
        private Timestamp dateCreated;
        private Timestamp dateUpdated;
        private String name;
        private String config;
        private Boolean enabled;
        private String role;
        private Integer sort;
        private byte[] pluginJar;

        private PluginDOBuilder() {
        }

        public PluginDOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public PluginDOBuilder dateCreated(Timestamp dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public PluginDOBuilder dateUpdated(Timestamp dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public PluginDOBuilder name(String name) {
            this.name = name;
            return this;
        }

        public PluginDOBuilder config(String config) {
            this.config = config;
            return this;
        }

        public PluginDOBuilder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public PluginDOBuilder role(String role) {
            this.role = role;
            return this;
        }

        public PluginDOBuilder sort(Integer sort) {
            this.sort = sort;
            return this;
        }

        public PluginDOBuilder pluginJar(byte[] pluginJar) {
            this.pluginJar = pluginJar;
            return this;
        }

        public PluginDO build() {
            PluginDO pluginDO = new PluginDO();
            pluginDO.setId(this.id);
            pluginDO.setDateCreated(this.dateCreated);
            pluginDO.setDateUpdated(this.dateUpdated);
            pluginDO.setName(this.name);
            pluginDO.setConfig(this.config);
            pluginDO.setEnabled(this.enabled);
            pluginDO.setRole(this.role);
            pluginDO.setSort(this.sort);
            pluginDO.setPluginJar(this.pluginJar);
            return pluginDO;
        }
    }
}

