/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.entity;

import java.sql.Timestamp;
import java.util.Objects;
import java.util.Optional;
import org.apache.shenyu.admin.model.dto.NamespacePluginDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.admin.model.entity.PluginDO;
import org.apache.shenyu.common.utils.UUIDUtils;

public final class NamespacePluginRelDO
extends BaseDO {
    private String namespaceId;
    private String pluginId;
    private String config;
    private Boolean enabled;
    private Integer sort;

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public void setNamespaceId(String namespaceId) {
        this.namespaceId = namespaceId;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Integer getSort() {
        return this.sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (Objects.isNull(o) || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamespacePluginRelDO that = (NamespacePluginRelDO)o;
        return Objects.equals(this.namespaceId, that.namespaceId) && Objects.equals(this.pluginId, that.pluginId) && Objects.equals(this.config, that.config) && Objects.equals(this.enabled, that.enabled) && Objects.equals(this.sort, that.sort);
    }

    public static NamespacePluginRelDO buildNamespacePluginRelDO(NamespacePluginDTO namespacePluginDTO) {
        return Optional.ofNullable(namespacePluginDTO).map(item -> {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            return NamespacePluginRelDO.builder().id(item.getId()).config(item.getConfig()).enabled(item.getEnabled()).sort(item.getSort()).namespaceId(item.getNamespaceId()).pluginId(item.getPluginId()).dateUpdated(currentTime).build();
        }).orElse(null);
    }

    public static NamespacePluginRelDO buildNamespacePluginRelDO(PluginDO pluginDO, String namespaceId) {
        return Optional.ofNullable(pluginDO).map(item -> {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            return NamespacePluginRelDO.builder().id(UUIDUtils.getInstance().generateShortUuid()).config(item.getConfig()).enabled(item.getEnabled()).sort(item.getSort()).namespaceId(namespaceId).pluginId(item.getId()).dateUpdated(currentTime).dateCreated(currentTime).build();
        }).orElse(null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.namespaceId, this.pluginId, this.config, this.enabled, this.sort);
    }

    public static PluginNsRelDOBuilder builder() {
        return new PluginNsRelDOBuilder();
    }

    public static final class PluginNsRelDOBuilder {
        private String id;
        private Timestamp dateCreated;
        private Timestamp dateUpdated;
        private String namespaceId;
        private String pluginId;
        private String config;
        private Boolean enabled;
        private Integer sort;

        private PluginNsRelDOBuilder() {
        }

        public PluginNsRelDOBuilder id(String id) {
            this.id = id;
            return this;
        }

        public PluginNsRelDOBuilder dateCreated(Timestamp dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public PluginNsRelDOBuilder dateUpdated(Timestamp dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public PluginNsRelDOBuilder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        public PluginNsRelDOBuilder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        public PluginNsRelDOBuilder config(String config) {
            this.config = config;
            return this;
        }

        public PluginNsRelDOBuilder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public PluginNsRelDOBuilder sort(Integer sort) {
            this.sort = sort;
            return this;
        }

        public NamespacePluginRelDO build() {
            NamespacePluginRelDO namespacePluginRelDO = new NamespacePluginRelDO();
            namespacePluginRelDO.setId(this.id);
            namespacePluginRelDO.setDateCreated(this.dateCreated);
            namespacePluginRelDO.setDateUpdated(this.dateUpdated);
            namespacePluginRelDO.setNamespaceId(this.namespaceId);
            namespacePluginRelDO.setPluginId(this.pluginId);
            namespacePluginRelDO.setConfig(this.config);
            namespacePluginRelDO.setEnabled(this.enabled);
            namespacePluginRelDO.setSort(this.sort);
            return namespacePluginRelDO;
        }
    }
}

