/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.model.entity;

import java.sql.Timestamp;
import java.util.Optional;
import org.apache.shenyu.admin.model.dto.DiscoveryUpstreamDTO;
import org.apache.shenyu.admin.model.entity.BaseDO;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.springframework.util.StringUtils;

public class DiscoveryUpstreamDO
extends BaseDO {
    private static final long serialVersionUID = 4636503463949130337L;
    private String discoveryHandlerId;
    private String protocol;
    private String url;
    private int status;
    private int weight;
    private String props;
    private String namespaceId;

    public DiscoveryUpstreamDO() {
    }

    public DiscoveryUpstreamDO(String discoveryHandlerId, String protocol, String url, int status, int weight, String props) {
        this.discoveryHandlerId = discoveryHandlerId;
        this.protocol = protocol;
        this.url = url;
        this.status = status;
        this.weight = weight;
        this.props = props;
    }

    public String getDiscoveryHandlerId() {
        return this.discoveryHandlerId;
    }

    public void setDiscoveryHandlerId(String discoveryHandlerId) {
        this.discoveryHandlerId = discoveryHandlerId;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int weight) {
        this.weight = weight;
    }

    public String getProps() {
        return this.props;
    }

    public void setProps(String props) {
        this.props = props;
    }

    public static DiscoveryUpstreamBuilder builder() {
        return new DiscoveryUpstreamBuilder();
    }

    public String getNamespaceId() {
        return this.namespaceId;
    }

    public void setNamespaceId(String namespaceId) {
        this.namespaceId = namespaceId;
    }

    public static DiscoveryUpstreamDO buildDiscoveryUpstreamDO(DiscoveryUpstreamDTO discoveryUpstreamDTO) {
        return Optional.ofNullable(discoveryUpstreamDTO).map(item -> {
            Timestamp currentTime = new Timestamp(System.currentTimeMillis());
            DiscoveryUpstreamDO discoveryUpstreamDO = DiscoveryUpstreamDO.builder().discoveryHandlerId(item.getDiscoveryHandlerId()).protocol(item.getProtocol()).status(item.getStatus()).weight(item.getWeight()).props(item.getProps()).url(item.getUrl()).namespaceId(item.getNamespaceId()).dateCreated(currentTime).dateUpdated(currentTime).build();
            if (StringUtils.hasLength((String)item.getId())) {
                discoveryUpstreamDO.setId(item.getId());
            } else {
                discoveryUpstreamDO.setId(UUIDUtils.getInstance().generateShortUuid());
                discoveryUpstreamDO.setDateCreated(currentTime);
            }
            return discoveryUpstreamDO;
        }).orElse(null);
    }

    public static final class DiscoveryUpstreamBuilder {
        private String id;
        private Timestamp dateCreated;
        private Timestamp dateUpdated;
        private String discoveryHandlerId;
        private String protocol;
        private String url;
        private int status;
        private int weight;
        private String props;
        private String namespaceId;

        public DiscoveryUpstreamBuilder id(String id) {
            this.id = id;
            return this;
        }

        public DiscoveryUpstreamBuilder dateCreated(Timestamp dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public DiscoveryUpstreamBuilder dateUpdated(Timestamp dateUpdated) {
            this.dateUpdated = dateUpdated;
            return this;
        }

        public DiscoveryUpstreamBuilder discoveryHandlerId(String discoveryHandlerId) {
            this.discoveryHandlerId = discoveryHandlerId;
            return this;
        }

        public DiscoveryUpstreamBuilder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public DiscoveryUpstreamBuilder url(String url) {
            this.url = url;
            return this;
        }

        public DiscoveryUpstreamBuilder status(int status) {
            this.status = status;
            return this;
        }

        public DiscoveryUpstreamBuilder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public DiscoveryUpstreamBuilder props(String props) {
            this.props = props;
            return this;
        }

        public DiscoveryUpstreamBuilder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }

        public DiscoveryUpstreamDO build() {
            DiscoveryUpstreamDO discoveryUpstreamDO = new DiscoveryUpstreamDO();
            discoveryUpstreamDO.setId(this.id);
            discoveryUpstreamDO.setDiscoveryHandlerId(this.discoveryHandlerId);
            discoveryUpstreamDO.setProtocol(this.protocol);
            discoveryUpstreamDO.setUrl(this.url);
            discoveryUpstreamDO.setStatus(this.status);
            discoveryUpstreamDO.setWeight(this.weight);
            discoveryUpstreamDO.setProps(this.props);
            discoveryUpstreamDO.setNamespaceId(this.namespaceId);
            discoveryUpstreamDO.setDateCreated(this.dateCreated);
            discoveryUpstreamDO.setDateUpdated(this.dateUpdated);
            return discoveryUpstreamDO;
        }
    }
}

