/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener;

import jakarta.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.mode.ShenyuRunningModeService;
import org.apache.shenyu.admin.utils.ShenyuDomain;
import org.apache.shenyu.common.utils.IpUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class ApplicationStartListener
implements ApplicationListener<WebServerInitializedEvent> {
    @Value(value="${server.servlet.context-path:}")
    private String contextPath;
    @Resource
    private ShenyuRunningModeService shenyuRunningModeService;

    public void onApplicationEvent(WebServerInitializedEvent event) {
        int port = event.getWebServer().getPort();
        String host = IpUtils.getHost();
        String domain = System.getProperty("shenyu.httpPath");
        if (StringUtils.isBlank((CharSequence)domain)) {
            domain = System.getenv("shenyu.httpPath");
        }
        if (StringUtils.isBlank((CharSequence)domain)) {
            ShenyuDomain.getInstance().setHttpPath("http://" + String.join((CharSequence)":", host, String.valueOf(port)) + this.contextPath);
        } else {
            ShenyuDomain.getInstance().setHttpPath(domain);
        }
        this.shenyuRunningModeService.start(host, port, this.contextPath);
    }
}

