/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.config;

import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import org.apache.shenyu.common.utils.VersionUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SwaggerConfiguration {
    private static final String DEFAULT_SWAGGER_API_VERSION = "2.3.0";
    private static final String TITLE = "ShenYu Admin API Document";
    private static final String DESCRIPTION = "ShenYu Admin API";
    private static final String CONTACT_NAME = "ShenYu";
    private static final String CONTACT_URL = "https://github.com/apache/shenyu";
    private static final String CONTACT_EMAIL = "dev@shenyu.apache.org";
    private static final String TOKEN_DESCRIPTION = "user auth";

    @Bean
    public OpenAPI apiInfo() {
        return new OpenAPI().info(new Info().title(TITLE).description(DESCRIPTION).version(VersionUtils.getVersion(this.getClass(), (String)DEFAULT_SWAGGER_API_VERSION)).contact(new Contact().name(CONTACT_NAME).url(CONTACT_URL).email(CONTACT_EMAIL))).components(new Components().addSecuritySchemes("X-Access-Token", new SecurityScheme().name("X-Access-Token").type(SecurityScheme.Type.APIKEY).in(SecurityScheme.In.HEADER).description(TOKEN_DESCRIPTION))).addSecurityItem(new SecurityRequirement().addList("X-Access-Token"));
    }
}

