/*
 * Decompiled with CFR 0.152.
 */
package shade.polaris.io.grpc.okhttp;

import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import shade.polaris.io.grpc.Attributes;
import shade.polaris.io.grpc.Grpc;
import shade.polaris.io.grpc.InternalChannelz;
import shade.polaris.io.grpc.SecurityLevel;
import shade.polaris.io.grpc.internal.GrpcAttributes;
import shade.polaris.io.grpc.okhttp.HandshakerSocketFactory;
import shade.polaris.io.grpc.okhttp.OkHttpProtocolNegotiator;
import shade.polaris.io.grpc.okhttp.PlaintextHandshakerSocketFactory;
import shade.polaris.io.grpc.okhttp.SslSocketFactoryServerCredentials;
import shade.polaris.io.grpc.okhttp.internal.ConnectionSpec;
import shade.polaris.io.grpc.okhttp.internal.Protocol;

final class TlsServerHandshakerSocketFactory
implements HandshakerSocketFactory {
    private final PlaintextHandshakerSocketFactory delegate = new PlaintextHandshakerSocketFactory();
    private final SSLSocketFactory socketFactory;
    private final ConnectionSpec connectionSpec;

    public TlsServerHandshakerSocketFactory(SslSocketFactoryServerCredentials.ServerCredentials credentials) {
        this.socketFactory = credentials.getFactory();
        this.connectionSpec = credentials.getConnectionSpec();
    }

    @Override
    public HandshakerSocketFactory.HandshakeResult handshake(Socket socket, Attributes attributes) throws IOException {
        HandshakerSocketFactory.HandshakeResult result = this.delegate.handshake(socket, attributes);
        socket = this.socketFactory.createSocket(result.socket, null, -1, true);
        if (!(socket instanceof SSLSocket)) {
            throw new IOException("SocketFactory " + this.socketFactory + " did not produce an SSLSocket: " + socket.getClass());
        }
        SSLSocket sslSocket = (SSLSocket)socket;
        sslSocket.setUseClientMode(false);
        this.connectionSpec.apply(sslSocket, false);
        Protocol expectedProtocol = Protocol.HTTP_2;
        String negotiatedProtocol = OkHttpProtocolNegotiator.get().negotiate(sslSocket, null, this.connectionSpec.supportsTlsExtensions() ? Arrays.asList(expectedProtocol) : null);
        if (!expectedProtocol.toString().equals(negotiatedProtocol)) {
            throw new IOException("Expected NPN/ALPN " + (Object)((Object)expectedProtocol) + ": " + negotiatedProtocol);
        }
        attributes = result.attributes.toBuilder().set(GrpcAttributes.ATTR_SECURITY_LEVEL, SecurityLevel.PRIVACY_AND_INTEGRITY).set(Grpc.TRANSPORT_ATTR_SSL_SESSION, sslSocket.getSession()).build();
        return new HandshakerSocketFactory.HandshakeResult(socket, attributes, new InternalChannelz.Security(new InternalChannelz.Tls(sslSocket.getSession())));
    }
}

