/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.integration.util.MessagingAnnotationUtils;
import org.springframework.util.StringUtils;

public interface MethodAnnotationPostProcessor<T extends Annotation> {
    public static final String INPUT_CHANNEL_ATTRIBUTE = "inputChannel";

    public Object postProcess(Object var1, String var2, Method var3, List<Annotation> var4);

    public void processBeanDefinition(String var1, AnnotatedBeanDefinition var2, List<Annotation> var3);

    default public boolean shouldCreateEndpoint(Method method, List<Annotation> annotations) {
        return this.shouldCreateEndpoint(MergedAnnotations.from((AnnotatedElement)method), annotations);
    }

    default public boolean shouldCreateEndpoint(MergedAnnotations mergedAnnotations, List<Annotation> annotations) {
        String inputChannel = MessagingAnnotationUtils.resolveAttribute(annotations, this.getInputChannelAttribute(), String.class);
        return StringUtils.hasText((String)inputChannel);
    }

    default public String getInputChannelAttribute() {
        return INPUT_CHANNEL_ATTRIBUTE;
    }

    default public boolean beanAnnotationAware() {
        return true;
    }

    default public boolean supportsPojoMethod() {
        return true;
    }
}

