/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.ResolvableType;
import org.springframework.integration.annotation.Transformer;
import org.springframework.integration.config.AbstractMethodAnnotationPostProcessor;
import org.springframework.integration.config.TransformerFactoryBean;
import org.springframework.integration.transformer.MessageTransformingHandler;
import org.springframework.integration.transformer.MethodInvokingTransformer;
import org.springframework.messaging.MessageHandler;

public class TransformerAnnotationPostProcessor
extends AbstractMethodAnnotationPostProcessor<Transformer> {
    public TransformerAnnotationPostProcessor() {
        this.messageHandlerAttributes.addAll(Arrays.asList("outputChannel", "adviceChain"));
    }

    @Override
    protected BeanDefinition resolveHandlerBeanDefinition(String beanName, AnnotatedBeanDefinition beanDefinition, ResolvableType handlerBeanType, List<Annotation> annotations) {
        BeanDefinition handlerBeanDefinition = super.resolveHandlerBeanDefinition(beanName, beanDefinition, handlerBeanType, annotations);
        if (handlerBeanDefinition != null) {
            return handlerBeanDefinition;
        }
        BeanDefinition targetObjectBeanDefinition = TransformerAnnotationPostProcessor.buildLambdaMessageProcessor(handlerBeanType, beanDefinition);
        if (targetObjectBeanDefinition == null) {
            targetObjectBeanDefinition = new RuntimeBeanReference(beanName);
        }
        return BeanDefinitionBuilder.genericBeanDefinition(TransformerFactoryBean.class).addPropertyValue("targetObject", (Object)targetObjectBeanDefinition).getBeanDefinition();
    }

    @Override
    protected MessageHandler createHandler(Object bean, Method method, List<Annotation> annotations) {
        MethodInvokingTransformer transformer2 = new MethodInvokingTransformer(bean, method);
        MessageTransformingHandler handler = new MessageTransformingHandler(transformer2);
        TransformerAnnotationPostProcessor.setOutputChannelIfPresent(annotations, handler);
        return handler;
    }
}

