/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.lang.Nullable;
import org.springframework.scheduling.support.PeriodicTrigger;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PeriodicTriggerFactoryBean
implements FactoryBean<PeriodicTrigger> {
    @Nullable
    private String fixedDelayValue;
    @Nullable
    private String fixedRateValue;
    @Nullable
    private String initialDelayValue;
    @Nullable
    private TimeUnit timeUnit;

    public void setFixedDelayValue(String fixedDelayValue) {
        this.fixedDelayValue = fixedDelayValue;
    }

    public void setFixedRateValue(String fixedRateValue) {
        this.fixedRateValue = fixedRateValue;
    }

    public void setInitialDelayValue(String initialDelayValue) {
        this.initialDelayValue = initialDelayValue;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public PeriodicTrigger getObject() {
        boolean hasFixedDelay = StringUtils.hasText((String)this.fixedDelayValue);
        boolean hasFixedRate = StringUtils.hasText((String)this.fixedRateValue);
        Assert.isTrue((boolean)(hasFixedDelay ^ hasFixedRate), (String)"One of the 'fixedDelayValue' or 'fixedRateValue' property must be provided but not both.");
        TimeUnit timeUnitToUse = this.timeUnit;
        if (timeUnitToUse == null) {
            timeUnitToUse = TimeUnit.MILLISECONDS;
        }
        Duration duration = PeriodicTriggerFactoryBean.toDuration(hasFixedDelay ? this.fixedDelayValue : this.fixedRateValue, timeUnitToUse);
        PeriodicTrigger periodicTrigger = new PeriodicTrigger(duration);
        periodicTrigger.setFixedRate(hasFixedRate);
        if (StringUtils.hasText((String)this.initialDelayValue)) {
            periodicTrigger.setInitialDelay(PeriodicTriggerFactoryBean.toDuration(this.initialDelayValue, timeUnitToUse));
        }
        return periodicTrigger;
    }

    public Class<?> getObjectType() {
        return PeriodicTrigger.class;
    }

    private static Duration toDuration(String value, TimeUnit timeUnit) {
        if (PeriodicTriggerFactoryBean.isDurationString(value)) {
            return Duration.parse(value);
        }
        return PeriodicTriggerFactoryBean.toDuration(Long.parseLong(value), timeUnit);
    }

    private static boolean isDurationString(String value) {
        return value.length() > 1 && (PeriodicTriggerFactoryBean.isP(value.charAt(0)) || PeriodicTriggerFactoryBean.isP(value.charAt(1)));
    }

    private static boolean isP(char ch) {
        return ch == 'P' || ch == 'p';
    }

    private static Duration toDuration(long value, TimeUnit timeUnit) {
        return Duration.of(value, timeUnit.toChronoUnit());
    }
}

