/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.scripting.xmltags;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.ibatis.scripting.xmltags.DynamicContext;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.session.Configuration;

public class TrimSqlNode
implements SqlNode {
    private final SqlNode contents;
    private final String prefix;
    private final String suffix;
    private final List<String> prefixesToOverride;
    private final List<String> suffixesToOverride;
    private final Configuration configuration;

    public TrimSqlNode(Configuration configuration, SqlNode contents, String prefix, String prefixesToOverride, String suffix, String suffixesToOverride) {
        this(configuration, contents, prefix, TrimSqlNode.parseOverrides(prefixesToOverride), suffix, TrimSqlNode.parseOverrides(suffixesToOverride));
    }

    protected TrimSqlNode(Configuration configuration, SqlNode contents, String prefix, List<String> prefixesToOverride, String suffix, List<String> suffixesToOverride) {
        this.contents = contents;
        this.prefix = prefix;
        this.prefixesToOverride = prefixesToOverride;
        this.suffix = suffix;
        this.suffixesToOverride = suffixesToOverride;
        this.configuration = configuration;
    }

    @Override
    public boolean apply(DynamicContext context) {
        FilteredDynamicContext filteredDynamicContext = new FilteredDynamicContext(context);
        boolean result = this.contents.apply(filteredDynamicContext);
        filteredDynamicContext.applyAll();
        return result;
    }

    private static List<String> parseOverrides(String overrides) {
        if (overrides != null) {
            StringTokenizer parser = new StringTokenizer(overrides, "|", false);
            ArrayList<String> list = new ArrayList<String>(parser.countTokens());
            while (parser.hasMoreTokens()) {
                list.add(parser.nextToken().toUpperCase(Locale.ENGLISH));
            }
            return list;
        }
        return Collections.emptyList();
    }

    private class FilteredDynamicContext
    extends DynamicContext {
        private final DynamicContext delegate;
        private boolean prefixApplied;
        private boolean suffixApplied;
        private StringBuilder sqlBuffer;

        public FilteredDynamicContext(DynamicContext delegate) {
            super(TrimSqlNode.this.configuration, null);
            this.delegate = delegate;
            this.prefixApplied = false;
            this.suffixApplied = false;
            this.sqlBuffer = new StringBuilder();
        }

        public void applyAll() {
            this.sqlBuffer = new StringBuilder(this.sqlBuffer.toString().trim());
            String trimmedUppercaseSql = this.sqlBuffer.toString().toUpperCase(Locale.ENGLISH);
            if (trimmedUppercaseSql.length() > 0) {
                this.applyPrefix(this.sqlBuffer, trimmedUppercaseSql);
                this.applySuffix(this.sqlBuffer, trimmedUppercaseSql);
            }
            this.delegate.appendSql(this.sqlBuffer.toString());
        }

        @Override
        public Map<String, Object> getBindings() {
            return this.delegate.getBindings();
        }

        @Override
        public void bind(String name, Object value) {
            this.delegate.bind(name, value);
        }

        @Override
        public int getUniqueNumber() {
            return this.delegate.getUniqueNumber();
        }

        @Override
        public void appendSql(String sql) {
            this.sqlBuffer.append(sql);
        }

        @Override
        public String getSql() {
            return this.delegate.getSql();
        }

        private void applyPrefix(StringBuilder sql, String trimmedUppercaseSql) {
            if (this.prefixApplied) {
                return;
            }
            this.prefixApplied = true;
            if (TrimSqlNode.this.prefixesToOverride != null) {
                TrimSqlNode.this.prefixesToOverride.stream().filter(trimmedUppercaseSql::startsWith).findFirst().ifPresent(toRemove -> sql.delete(0, toRemove.trim().length()));
            }
            if (TrimSqlNode.this.prefix != null) {
                sql.insert(0, " ").insert(0, TrimSqlNode.this.prefix);
            }
        }

        private void applySuffix(StringBuilder sql, String trimmedUppercaseSql) {
            if (this.suffixApplied) {
                return;
            }
            this.suffixApplied = true;
            if (TrimSqlNode.this.suffixesToOverride != null) {
                TrimSqlNode.this.suffixesToOverride.stream().filter(toRemove -> trimmedUppercaseSql.endsWith((String)toRemove) || trimmedUppercaseSql.endsWith(toRemove.trim())).findFirst().ifPresent(toRemove -> {
                    int start = sql.length() - toRemove.trim().length();
                    int end = sql.length();
                    sql.delete(start, end);
                });
            }
            if (TrimSqlNode.this.suffix != null) {
                sql.append(" ").append(TrimSqlNode.this.suffix);
            }
        }
    }
}

