/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.server;

import io.vertx.core.Handler;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.impl.NetSocketImpl;
import org.apache.servicecomb.foundation.vertx.server.TcpParser;
import org.apache.servicecomb.foundation.vertx.tcp.TcpConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpServerConnection
extends TcpConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpServerConnection.class);
    protected TcpParser splitter;

    public void init(NetSocket netSocket) {
        this.initNetSocket((NetSocketImpl)netSocket);
        String remoteAddress = netSocket.remoteAddress().toString();
        LOGGER.info("connect from {}, in thread {}", (Object)remoteAddress, (Object)Thread.currentThread().getName());
        netSocket.exceptionHandler(e -> LOGGER.error("disconnected from {}, in thread {}, cause {}", new Object[]{remoteAddress, Thread.currentThread().getName(), e.getMessage()}));
        netSocket.closeHandler(Void2 -> LOGGER.info("disconnected from {}, in thread {}", (Object)remoteAddress, (Object)Thread.currentThread().getName()));
        netSocket.handler((Handler)this.splitter);
    }
}

