/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;

public class AttributeContainerMutable
implements AttributeContainer {
    @Nullable
    private String name;
    private List<Attribute> atts;

    public static AttributeContainerMutable copyFrom(@Nullable AttributeContainer from) {
        return from == null ? new AttributeContainerMutable(null) : new AttributeContainerMutable(from.getName(), from);
    }

    public AttributeContainerMutable(@Nullable String name) {
        this.name = name;
        this.atts = new ArrayList<Attribute>();
    }

    public AttributeContainerMutable(@Nullable String name, Iterable<Attribute> from) {
        this(name);
        this.addAll(from);
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    @Deprecated
    public void setImmutable() {
        this.atts = Collections.unmodifiableList(this.atts);
    }

    @Override
    public List<Attribute> getAttributes() {
        return this.atts;
    }

    @Override
    public Attribute addAttribute(Attribute att) {
        if (att == null) {
            return null;
        }
        for (int i = 0; i < this.atts.size(); ++i) {
            Attribute a = this.atts.get(i);
            if (!att.getShortName().equals(a.getShortName())) continue;
            this.atts.set(i, att);
            return att;
        }
        this.atts.add(att);
        return att;
    }

    public Attribute addAttribute(String name, String value) {
        if (name == null || value == null) {
            return null;
        }
        Attribute att = new Attribute(name, value);
        return this.addAttribute(att);
    }

    public Attribute addAttribute(String name, Number value) {
        if (name == null || value == null) {
            return null;
        }
        Attribute att = new Attribute(name, value);
        return this.addAttribute(att);
    }

    @Override
    public void addAll(Iterable<Attribute> atts) {
        for (Attribute att : atts) {
            this.addAttribute(att);
        }
    }

    @Override
    public String findAttributeString(String attName, String defaultValue) {
        String attValue = null;
        Attribute att = this.findAttributeIgnoreCase(attName);
        if (att != null && att.isString()) {
            attValue = att.getStringValue();
        }
        if (null == attValue) {
            attValue = defaultValue;
        }
        return attValue;
    }

    @Override
    public Attribute findAttribute(String name) {
        for (Attribute a : this.atts) {
            if (!name.equals(a.getShortName())) continue;
            return a;
        }
        return null;
    }

    @Override
    public Attribute findAttributeIgnoreCase(String name) {
        Attribute result = this.findAttribute(name);
        return result != null ? result : (Attribute)this.atts.stream().filter(a -> a.getShortName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }

    @Override
    public double findAttributeDouble(String attName, double defaultValue) {
        Attribute att = this.findAttributeIgnoreCase(attName);
        if (att == null) {
            return defaultValue;
        }
        if (att.isString()) {
            return Double.parseDouble(att.getStringValue());
        }
        return att.getNumericValue().doubleValue();
    }

    @Override
    public int findAttributeInteger(String attName, int defaultValue) {
        Attribute att = this.findAttributeIgnoreCase(attName);
        if (att == null) {
            return defaultValue;
        }
        if (att.isString()) {
            return Integer.parseInt(att.getStringValue());
        }
        return att.getNumericValue().intValue();
    }

    @Override
    public boolean remove(Attribute a) {
        return a != null && this.atts.remove(a);
    }

    public void replace(Attribute a, String newName) {
        this.atts.remove(a);
        Attribute newAtt = a.toBuilder().setName(newName).build();
        this.addAttribute(newAtt);
    }

    @Override
    public boolean removeAttribute(String attName) {
        Attribute att = this.findAttribute(attName);
        return att != null && this.atts.remove(att);
    }

    @Override
    public boolean removeAttributeIgnoreCase(String attName) {
        Attribute att = this.findAttributeIgnoreCase(attName);
        return att != null && this.atts.remove(att);
    }

    public AttributeContainer toImmutable() {
        return new AttributeContainerImmutable(this.name, this.atts);
    }

    @Override
    public boolean isEmpty() {
        return this.atts.isEmpty();
    }

    @Immutable
    private static class AttributeContainerImmutable
    implements AttributeContainer {
        private final String name;
        private final ImmutableList<Attribute> atts;

        private AttributeContainerImmutable(String name, List<Attribute> atts) {
            this.name = name;
            this.atts = ImmutableList.copyOf(atts);
        }

        @Override
        public List<Attribute> getAttributes() {
            return this.atts;
        }

        @Override
        public String findAttributeString(String attName, String defaultValue) {
            return this.atts.stream().filter(a -> a.getShortName().equals(attName)).findFirst().map(Attribute::getStringValue).orElse(defaultValue);
        }

        @Override
        public Attribute findAttribute(String attName) {
            return this.atts.stream().filter(a -> a.getShortName().equals(attName)).findFirst().orElse(null);
        }

        @Override
        public Attribute findAttributeIgnoreCase(String attName) {
            Attribute result = this.findAttribute(attName);
            return result != null ? result : (Attribute)this.atts.stream().filter(a -> a.getShortName().equalsIgnoreCase(attName)).findFirst().orElse(null);
        }

        @Override
        public double findAttributeDouble(String attName, double defaultValue) {
            Attribute att = this.findAttributeIgnoreCase(attName);
            if (att == null) {
                return defaultValue;
            }
            if (att.isString()) {
                return Double.parseDouble(att.getStringValue());
            }
            return att.getNumericValue().doubleValue();
        }

        @Override
        public int findAttributeInteger(String attName, int defaultValue) {
            Attribute att = this.findAttributeIgnoreCase(attName);
            if (att == null) {
                return defaultValue;
            }
            if (att.isString()) {
                return Integer.parseInt(att.getStringValue());
            }
            return att.getNumericValue().intValue();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isEmpty() {
            return this.atts.isEmpty();
        }

        @Override
        @Deprecated
        public void addAll(Iterable<Attribute> atts) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public Attribute addAttribute(Attribute att) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public boolean remove(Attribute a) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public boolean removeAttribute(String attName) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public boolean removeAttributeIgnoreCase(String attName) {
            throw new UnsupportedOperationException();
        }
    }
}

