/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.relateng;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.locationtech.jts.algorithm.BoundaryNodeRule;
import org.locationtech.jts.algorithm.Orientation;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryCollectionIterator;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.ComponentCoordinateExtracter;
import org.locationtech.jts.geom.util.PointExtracter;
import org.locationtech.jts.operation.relateng.DimensionLocation;
import org.locationtech.jts.operation.relateng.RelatePointLocator;
import org.locationtech.jts.operation.relateng.RelateSegmentString;

class RelateGeometry {
    public static final boolean GEOM_A = true;
    public static final boolean GEOM_B = false;
    private Geometry geom;
    private boolean isPrepared = false;
    private Envelope geomEnv;
    private int geomDim = -1;
    private Set<Coordinate> uniquePoints;
    private BoundaryNodeRule boundaryNodeRule;
    private RelatePointLocator locator;
    private int elementId = 0;
    private boolean hasPoints;
    private boolean hasLines;
    private boolean hasAreas;
    private boolean isLineZeroLen;
    private boolean isGeomEmpty;

    public static String name(boolean isA) {
        return isA ? "A" : "B";
    }

    public RelateGeometry(Geometry input) {
        this(input, false, BoundaryNodeRule.OGC_SFS_BOUNDARY_RULE);
    }

    public RelateGeometry(Geometry input, BoundaryNodeRule bnRule) {
        this(input, false, bnRule);
    }

    public RelateGeometry(Geometry input, boolean isPrepared, BoundaryNodeRule bnRule) {
        this.geom = input;
        this.geomEnv = input.getEnvelopeInternal();
        this.isPrepared = isPrepared;
        this.boundaryNodeRule = bnRule;
        this.isGeomEmpty = this.geom.isEmpty();
        this.geomDim = input.getDimension();
        this.analyzeDimensions();
        this.isLineZeroLen = this.isZeroLengthLine(this.geom);
    }

    private boolean isZeroLengthLine(Geometry geom) {
        if (this.getDimension() != 1) {
            return false;
        }
        return RelateGeometry.isZeroLength(geom);
    }

    private void analyzeDimensions() {
        if (this.isGeomEmpty) {
            return;
        }
        if (this.geom instanceof Point || this.geom instanceof MultiPoint) {
            this.hasPoints = true;
            this.geomDim = 0;
            return;
        }
        if (this.geom instanceof LineString || this.geom instanceof MultiLineString) {
            this.hasLines = true;
            this.geomDim = 1;
            return;
        }
        if (this.geom instanceof Polygon || this.geom instanceof MultiPolygon) {
            this.hasAreas = true;
            this.geomDim = 2;
            return;
        }
        GeometryCollectionIterator geomi = new GeometryCollectionIterator(this.geom);
        while (geomi.hasNext()) {
            Geometry elem = (Geometry)geomi.next();
            if (elem.isEmpty()) continue;
            if (elem instanceof Point) {
                this.hasPoints = true;
                if (this.geomDim < 0) {
                    this.geomDim = 0;
                }
            }
            if (elem instanceof LineString) {
                this.hasLines = true;
                if (this.geomDim < 1) {
                    this.geomDim = 1;
                }
            }
            if (!(elem instanceof Polygon)) continue;
            this.hasAreas = true;
            if (this.geomDim >= 2) continue;
            this.geomDim = 2;
        }
    }

    private static boolean isZeroLength(Geometry geom) {
        GeometryCollectionIterator geomi = new GeometryCollectionIterator(geom);
        while (geomi.hasNext()) {
            Geometry elem = (Geometry)geomi.next();
            if (!(elem instanceof LineString) || RelateGeometry.isZeroLength((LineString)elem)) continue;
            return false;
        }
        return true;
    }

    private static boolean isZeroLength(LineString line) {
        if (line.getNumPoints() >= 2) {
            Coordinate p0 = line.getCoordinateN(0);
            for (int i = 0; i < line.getNumPoints(); ++i) {
                Coordinate pi = line.getCoordinateN(i);
                if (p0.equals2D(pi)) continue;
                return false;
            }
        }
        return true;
    }

    public Geometry getGeometry() {
        return this.geom;
    }

    public boolean isPrepared() {
        return this.isPrepared;
    }

    public Envelope getEnvelope() {
        return this.geomEnv;
    }

    public int getDimension() {
        return this.geomDim;
    }

    public boolean hasDimension(int dim) {
        switch (dim) {
            case 0: {
                return this.hasPoints;
            }
            case 1: {
                return this.hasLines;
            }
            case 2: {
                return this.hasAreas;
            }
        }
        return false;
    }

    public int getDimensionReal() {
        if (this.isGeomEmpty) {
            return -1;
        }
        if (this.getDimension() == 1 && this.isLineZeroLen) {
            return 0;
        }
        if (this.hasAreas) {
            return 2;
        }
        if (this.hasLines) {
            return 1;
        }
        return 0;
    }

    public boolean hasEdges() {
        return this.hasLines || this.hasAreas;
    }

    private RelatePointLocator getLocator() {
        if (this.locator == null) {
            this.locator = new RelatePointLocator(this.geom, this.isPrepared, this.boundaryNodeRule);
        }
        return this.locator;
    }

    public boolean isNodeInArea(Coordinate nodePt, Geometry parentPolygonal) {
        int loc = this.getLocator().locateNodeWithDim(nodePt, parentPolygonal);
        return loc == 120;
    }

    public int locateLineEndWithDim(Coordinate p) {
        return this.getLocator().locateLineEndWithDim(p);
    }

    public int locateAreaVertex(Coordinate pt) {
        return this.locateNode(pt, null);
    }

    public int locateNode(Coordinate pt, Geometry parentPolygonal) {
        return this.getLocator().locateNode(pt, parentPolygonal);
    }

    public int locateWithDim(Coordinate pt) {
        int loc = this.getLocator().locateWithDim(pt);
        return loc;
    }

    public boolean isSelfNodingRequired() {
        if (this.geom instanceof Point || this.geom instanceof MultiPoint || this.geom instanceof Polygon || this.geom instanceof MultiPolygon) {
            return false;
        }
        return !this.hasAreas || this.geom.getNumGeometries() != 1;
    }

    public boolean isPolygonal() {
        return this.geom instanceof Polygon || this.geom instanceof MultiPolygon;
    }

    public boolean isEmpty() {
        return this.isGeomEmpty;
    }

    public boolean hasBoundary() {
        return this.getLocator().hasBoundary();
    }

    public Set<Coordinate> getUniquePoints() {
        if (this.uniquePoints == null) {
            this.uniquePoints = this.createUniquePoints();
        }
        return this.uniquePoints;
    }

    private Set<Coordinate> createUniquePoints() {
        List pts = ComponentCoordinateExtracter.getCoordinates(this.geom);
        HashSet<Coordinate> set = new HashSet<Coordinate>();
        set.addAll(pts);
        return set;
    }

    public List<Point> getEffectivePoints() {
        List ptListAll = PointExtracter.getPoints(this.geom);
        if (this.getDimensionReal() <= 0) {
            return ptListAll;
        }
        ArrayList<Point> ptList = new ArrayList<Point>();
        for (Point p : ptListAll) {
            int locDim;
            if (p.isEmpty() || DimensionLocation.dimension(locDim = this.locateWithDim(p.getCoordinate())) != 0) continue;
            ptList.add(p);
        }
        return ptList;
    }

    public List<RelateSegmentString> extractSegmentStrings(boolean isA, Envelope env) {
        ArrayList<RelateSegmentString> segStrings = new ArrayList<RelateSegmentString>();
        this.extractSegmentStrings(isA, env, this.geom, segStrings);
        return segStrings;
    }

    private void extractSegmentStrings(boolean isA, Envelope env, Geometry geom, List<RelateSegmentString> segStrings) {
        MultiPolygon parentPolygonal = null;
        if (geom instanceof MultiPolygon) {
            parentPolygonal = (MultiPolygon)geom;
        }
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Geometry g2 = geom.getGeometryN(i);
            if (g2 instanceof GeometryCollection) {
                this.extractSegmentStrings(isA, env, g2, segStrings);
                continue;
            }
            this.extractSegmentStringsFromAtomic(isA, g2, parentPolygonal, env, segStrings);
        }
    }

    private void extractSegmentStringsFromAtomic(boolean isA, Geometry geom, MultiPolygon parentPolygonal, Envelope env, List<RelateSegmentString> segStrings) {
        boolean doExtract;
        if (geom.isEmpty()) {
            return;
        }
        boolean bl = doExtract = env == null || env.intersects(geom.getEnvelopeInternal());
        if (!doExtract) {
            return;
        }
        ++this.elementId;
        if (geom instanceof LineString) {
            RelateSegmentString ss = RelateSegmentString.createLine(geom.getCoordinates(), isA, this.elementId, this);
            segStrings.add(ss);
        } else if (geom instanceof Polygon) {
            Polygon poly = (Polygon)geom;
            Geometry parentPoly = parentPolygonal != null ? parentPolygonal : poly;
            this.extractRingToSegmentString(isA, poly.getExteriorRing(), 0, env, parentPoly, segStrings);
            for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
                this.extractRingToSegmentString(isA, poly.getInteriorRingN(i), i + 1, env, parentPoly, segStrings);
            }
        }
    }

    private void extractRingToSegmentString(boolean isA, LinearRing ring, int ringId, Envelope env, Geometry parentPoly, List<RelateSegmentString> segStrings) {
        if (ring.isEmpty()) {
            return;
        }
        if (env != null && !env.intersects(ring.getEnvelopeInternal())) {
            return;
        }
        boolean requireCW = ringId == 0;
        Coordinate[] pts = RelateGeometry.orient(ring.getCoordinates(), requireCW);
        RelateSegmentString ss = RelateSegmentString.createRing(pts, isA, this.elementId, ringId, parentPoly, this);
        segStrings.add(ss);
    }

    public static Coordinate[] orient(Coordinate[] pts, boolean orientCW) {
        boolean isFlipped;
        boolean bl = isFlipped = orientCW == Orientation.isCCW(pts);
        if (isFlipped) {
            pts = (Coordinate[])pts.clone();
            CoordinateArrays.reverse(pts);
        }
        return pts;
    }

    public String toString() {
        return this.geom.toString();
    }
}

