/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.geom;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import org.locationtech.jts.algorithm.Centroid;
import org.locationtech.jts.algorithm.ConvexHull;
import org.locationtech.jts.algorithm.InteriorPoint;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.CoordinateSequenceComparator;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryComponentFilter;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.GeometryFilter;
import org.locationtech.jts.geom.GeometryOverlay;
import org.locationtech.jts.geom.GeometryRelate;
import org.locationtech.jts.geom.IntersectionMatrix;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.operation.buffer.BufferOp;
import org.locationtech.jts.operation.distance.DistanceOp;
import org.locationtech.jts.operation.predicate.RectangleContains;
import org.locationtech.jts.operation.predicate.RectangleIntersects;
import org.locationtech.jts.operation.valid.IsSimpleOp;
import org.locationtech.jts.operation.valid.IsValidOp;
import org.locationtech.jts.util.Assert;

public abstract class Geometry
implements Cloneable,
Comparable,
Serializable {
    private static final long serialVersionUID = 8763622679187376702L;
    protected static final int TYPECODE_POINT = 0;
    protected static final int TYPECODE_MULTIPOINT = 1;
    protected static final int TYPECODE_LINESTRING = 2;
    protected static final int TYPECODE_LINEARRING = 3;
    protected static final int TYPECODE_MULTILINESTRING = 4;
    protected static final int TYPECODE_POLYGON = 5;
    protected static final int TYPECODE_MULTIPOLYGON = 6;
    protected static final int TYPECODE_GEOMETRYCOLLECTION = 7;
    public static final String TYPENAME_POINT = "Point";
    public static final String TYPENAME_MULTIPOINT = "MultiPoint";
    public static final String TYPENAME_LINESTRING = "LineString";
    public static final String TYPENAME_LINEARRING = "LinearRing";
    public static final String TYPENAME_MULTILINESTRING = "MultiLineString";
    public static final String TYPENAME_POLYGON = "Polygon";
    public static final String TYPENAME_MULTIPOLYGON = "MultiPolygon";
    public static final String TYPENAME_GEOMETRYCOLLECTION = "GeometryCollection";
    private static final GeometryComponentFilter geometryChangedFilter = new GeometryComponentFilter(){

        @Override
        public void filter(Geometry geom) {
            geom.geometryChangedAction();
        }
    };
    protected Envelope envelope;
    protected final GeometryFactory factory;
    protected int SRID;
    private Object userData = null;

    public Geometry(GeometryFactory factory) {
        this.factory = factory;
        this.SRID = factory.getSRID();
    }

    public abstract String getGeometryType();

    protected static boolean hasNonEmptyElements(Geometry[] geometries) {
        for (int i = 0; i < geometries.length; ++i) {
            if (geometries[i].isEmpty()) continue;
            return true;
        }
        return false;
    }

    protected static boolean hasNullElements(Object[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) continue;
            return true;
        }
        return false;
    }

    public int getSRID() {
        return this.SRID;
    }

    public void setSRID(int SRID) {
        this.SRID = SRID;
    }

    public GeometryFactory getFactory() {
        return this.factory;
    }

    public Object getUserData() {
        return this.userData;
    }

    public int getNumGeometries() {
        return 1;
    }

    public Geometry getGeometryN(int n) {
        return this;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public PrecisionModel getPrecisionModel() {
        return this.factory.getPrecisionModel();
    }

    public abstract Coordinate getCoordinate();

    public abstract Coordinate[] getCoordinates();

    public abstract int getNumPoints();

    public boolean isSimple() {
        IsSimpleOp op = new IsSimpleOp(this);
        return op.isSimple();
    }

    public boolean isValid() {
        return IsValidOp.isValid(this);
    }

    public abstract boolean isEmpty();

    public double distance(Geometry g2) {
        return DistanceOp.distance(this, g2);
    }

    public boolean isWithinDistance(Geometry geom, double distance) {
        return DistanceOp.isWithinDistance(this, geom, distance);
    }

    public boolean isRectangle() {
        return false;
    }

    public double getArea() {
        return 0.0;
    }

    public double getLength() {
        return 0.0;
    }

    public Point getCentroid() {
        if (this.isEmpty()) {
            return this.factory.createPoint();
        }
        Coordinate centPt = Centroid.getCentroid(this);
        return this.createPointFromInternalCoord(centPt, this);
    }

    public Point getInteriorPoint() {
        if (this.isEmpty()) {
            return this.factory.createPoint();
        }
        Coordinate pt = InteriorPoint.getInteriorPoint(this);
        return this.createPointFromInternalCoord(pt, this);
    }

    public abstract int getDimension();

    public boolean hasDimension(int dim) {
        return dim == this.getDimension();
    }

    public abstract Geometry getBoundary();

    public abstract int getBoundaryDimension();

    public Geometry getEnvelope() {
        return this.getFactory().toGeometry(this.getEnvelopeInternal());
    }

    public Envelope getEnvelopeInternal() {
        if (this.envelope == null) {
            this.envelope = this.computeEnvelopeInternal();
        }
        return new Envelope(this.envelope);
    }

    public void geometryChanged() {
        this.apply(geometryChangedFilter);
    }

    protected void geometryChangedAction() {
        this.envelope = null;
    }

    public boolean disjoint(Geometry g2) {
        return !this.intersects(g2);
    }

    public boolean touches(Geometry g2) {
        return GeometryRelate.touches(this, g2);
    }

    public boolean intersects(Geometry g2) {
        if (!this.getEnvelopeInternal().intersects(g2.getEnvelopeInternal())) {
            return false;
        }
        if (this.isRectangle()) {
            return RectangleIntersects.intersects((Polygon)this, g2);
        }
        if (g2.isRectangle()) {
            return RectangleIntersects.intersects((Polygon)g2, this);
        }
        return GeometryRelate.intersects(this, g2);
    }

    public boolean crosses(Geometry g2) {
        if (!this.getEnvelopeInternal().intersects(g2.getEnvelopeInternal())) {
            return false;
        }
        return this.relate(g2).isCrosses(this.getDimension(), g2.getDimension());
    }

    public boolean within(Geometry g2) {
        return GeometryRelate.within(this, g2);
    }

    public boolean contains(Geometry g2) {
        if (this.isRectangle()) {
            return RectangleContains.contains((Polygon)this, g2);
        }
        return GeometryRelate.contains(this, g2);
    }

    public boolean overlaps(Geometry g2) {
        return GeometryRelate.overlaps(this, g2);
    }

    public boolean covers(Geometry g2) {
        return GeometryRelate.covers(this, g2);
    }

    public boolean coveredBy(Geometry g2) {
        return GeometryRelate.coveredBy(this, g2);
    }

    public boolean relate(Geometry g2, String intersectionPattern) {
        return GeometryRelate.relate(this, g2, intersectionPattern);
    }

    public IntersectionMatrix relate(Geometry g2) {
        return GeometryRelate.relate(this, g2);
    }

    public boolean equals(Geometry g2) {
        if (g2 == null) {
            return false;
        }
        return this.equalsTopo(g2);
    }

    public boolean equalsTopo(Geometry g2) {
        return GeometryRelate.equalsTopo(this, g2);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Geometry)) {
            return false;
        }
        Geometry g2 = (Geometry)o;
        return this.equalsExact(g2);
    }

    public int hashCode() {
        return this.getEnvelopeInternal().hashCode();
    }

    public String toString() {
        return this.toText();
    }

    public String toText() {
        WKTWriter writer = new WKTWriter();
        return writer.write(this);
    }

    public Geometry buffer(double distance) {
        return BufferOp.bufferOp(this, distance);
    }

    public Geometry buffer(double distance, int quadrantSegments) {
        return BufferOp.bufferOp(this, distance, quadrantSegments);
    }

    public Geometry buffer(double distance, int quadrantSegments, int endCapStyle) {
        return BufferOp.bufferOp(this, distance, quadrantSegments, endCapStyle);
    }

    public Geometry convexHull() {
        return new ConvexHull(this).getConvexHull();
    }

    public Geometry reverse() {
        Geometry res = this.reverseInternal();
        if (this.envelope != null) {
            res.envelope = this.envelope.copy();
        }
        res.setSRID(this.getSRID());
        return res;
    }

    protected abstract Geometry reverseInternal();

    public Geometry intersection(Geometry other) {
        return GeometryOverlay.intersection(this, other);
    }

    public Geometry union(Geometry other) {
        return GeometryOverlay.union(this, other);
    }

    public Geometry difference(Geometry other) {
        return GeometryOverlay.difference(this, other);
    }

    public Geometry symDifference(Geometry other) {
        return GeometryOverlay.symDifference(this, other);
    }

    public Geometry union() {
        return GeometryOverlay.union(this);
    }

    public abstract boolean equalsExact(Geometry var1, double var2);

    public boolean equalsExact(Geometry other) {
        return this == other || this.equalsExact(other, 0.0);
    }

    public boolean equalsNorm(Geometry g2) {
        if (g2 == null) {
            return false;
        }
        return this.norm().equalsExact(g2.norm());
    }

    public abstract void apply(CoordinateFilter var1);

    public abstract void apply(CoordinateSequenceFilter var1);

    public abstract void apply(GeometryFilter var1);

    public abstract void apply(GeometryComponentFilter var1);

    public Object clone() {
        try {
            Geometry clone = (Geometry)super.clone();
            if (clone.envelope != null) {
                clone.envelope = new Envelope(clone.envelope);
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            Assert.shouldNeverReachHere();
            return null;
        }
    }

    public Geometry copy() {
        Geometry copy = this.copyInternal();
        copy.envelope = this.envelope == null ? null : this.envelope.copy();
        copy.SRID = this.SRID;
        copy.userData = this.userData;
        return copy;
    }

    protected abstract Geometry copyInternal();

    public abstract void normalize();

    public Geometry norm() {
        Geometry copy = this.copy();
        copy.normalize();
        return copy;
    }

    public int compareTo(Object o) {
        Geometry other = (Geometry)o;
        if (this.getTypeCode() != other.getTypeCode()) {
            return this.getTypeCode() - other.getTypeCode();
        }
        if (this.isEmpty() && other.isEmpty()) {
            return 0;
        }
        if (this.isEmpty()) {
            return -1;
        }
        if (other.isEmpty()) {
            return 1;
        }
        return this.compareToSameClass(o);
    }

    public int compareTo(Object o, CoordinateSequenceComparator comp) {
        Geometry other = (Geometry)o;
        if (this.getTypeCode() != other.getTypeCode()) {
            return this.getTypeCode() - other.getTypeCode();
        }
        if (this.isEmpty() && other.isEmpty()) {
            return 0;
        }
        if (this.isEmpty()) {
            return -1;
        }
        if (other.isEmpty()) {
            return 1;
        }
        return this.compareToSameClass(o, comp);
    }

    protected boolean isEquivalentClass(Geometry other) {
        return this.getClass().getName().equals(other.getClass().getName());
    }

    static void checkNotGeometryCollection(Geometry g2) {
        if (g2.isGeometryCollection()) {
            throw new IllegalArgumentException("Operation does not support GeometryCollection arguments");
        }
    }

    protected boolean isGeometryCollection() {
        return this.getTypeCode() == 7;
    }

    protected abstract Envelope computeEnvelopeInternal();

    protected abstract int compareToSameClass(Object var1);

    protected abstract int compareToSameClass(Object var1, CoordinateSequenceComparator var2);

    protected int compare(Collection a, Collection b) {
        Iterator i = a.iterator();
        Iterator j = b.iterator();
        while (i.hasNext() && j.hasNext()) {
            Comparable bElement;
            Comparable aElement = (Comparable)i.next();
            int comparison = aElement.compareTo(bElement = (Comparable)j.next());
            if (comparison == 0) continue;
            return comparison;
        }
        if (i.hasNext()) {
            return 1;
        }
        if (j.hasNext()) {
            return -1;
        }
        return 0;
    }

    protected boolean equal(Coordinate a, Coordinate b, double tolerance) {
        if (tolerance == 0.0) {
            return a.equals(b);
        }
        return a.distance(b) <= tolerance;
    }

    protected abstract int getTypeCode();

    private Point createPointFromInternalCoord(Coordinate coord, Geometry exemplar) {
        if (coord == null) {
            return exemplar.getFactory().createPoint();
        }
        exemplar.getPrecisionModel().makePrecise(coord);
        return exemplar.getFactory().createPoint(coord);
    }
}

