/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetToSparkSchemaConverter$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetUtils$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetSchemaConverter$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sedona_sql.UDT.GeometryUDT$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Ud\u0001B\r\u001b\u0001%B\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\t\t\u0002\u0011\t\u0011)A\u0005\u000b\"A\u0001\n\u0001B\u0001B\u0003%Q\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003F\u0011!Q\u0005A!A!\u0002\u0013Y\u0005\"B'\u0001\t\u0003q\u0005b\u0002,\u0001\u0005\u0004%Ia\u0016\u0005\u00077\u0002\u0001\u000b\u0011\u0002-\t\u000b5\u0003A\u0011\u0001/\t\u000b5\u0003A\u0011A4\t\u000bI\u0004A\u0011A:\t\u000bQ\u0004A\u0011A;\t\rQ\u0004A\u0011BA\u0006\u0011\u001d\t)\u0002\u0001C\u0001\u0003/Aq!!\u000b\u0001\t\u0013\tY\u0003C\u0004\u00022\u0001!I!a\r\t\u000f\u0005}\u0002\u0001\"\u0003\u0002B!9\u0011Q\t\u0001\u0005\u0002\u0005\u001ds!CA)5\u0005\u0005\t\u0012AA*\r!I\"$!A\t\u0002\u0005U\u0003BB'\u0015\t\u0003\t9\u0006C\u0005\u0002ZQ\t\n\u0011\"\u0001\u0002\\!I\u0011\u0011\u000f\u000b\u0012\u0002\u0013\u0005\u00111\f\u0005\n\u0003g\"\u0012\u0013!C\u0001\u00037\u0012\u0001eR3p!\u0006\u0014\u0018/^3u)>\u001c\u0006/\u0019:l'\u000eDW-\\1D_:4XM\u001d;fe*\u00111\u0004H\u0001\ba\u0006\u0014\u0018/^3u\u0015\tib$A\u0006eCR\f7o\\;sG\u0016\u001c(BA\u0010!\u0003%)\u00070Z2vi&|gN\u0003\u0002\"E\u0005\u00191/\u001d7\u000b\u0005\r\"\u0013!B:qCJ\\'BA\u0013'\u0003\u0019\t\u0007/Y2iK*\tq%A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001UA\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t1\u0011I\\=SK\u001a\f\u0001c[3z-\u0006dW/Z'fi\u0006$\u0015\r^1\u0011\tI:\u0014(O\u0007\u0002g)\u0011A'N\u0001\u0005kRLGNC\u00017\u0003\u0011Q\u0017M^1\n\u0005a\u001a$aA'baB\u0011!(\u0011\b\u0003w}\u0002\"\u0001\u0010\u0017\u000e\u0003uR!A\u0010\u0015\u0002\rq\u0012xn\u001c;?\u0013\t\u0001E&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0005\u000e\u0013aa\u0015;sS:<'B\u0001!-\u0003Q\t7o];nK\nKg.\u0019:z\u0013N\u001cFO]5oOB\u00111FR\u0005\u0003\u000f2\u0012qAQ8pY\u0016\fg.\u0001\fbgN,X.Z%oif2\u0014j\u001d+j[\u0016\u001cH/Y7q\u0003EIgNZ3s)&lWm\u001d;b[BtEKW\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\b\u0003\u0002\u001eMseJ!\u0001O\"\u0002\rqJg.\u001b;?)\u0019y\u0015KU*U+B\u0011\u0001\u000bA\u0007\u00025!)\u0001G\u0002a\u0001c!9AI\u0002I\u0001\u0002\u0004)\u0005b\u0002%\u0007!\u0003\u0005\r!\u0012\u0005\b\u0013\u001a\u0001\n\u00111\u0001F\u0011\u0015Qe\u00011\u0001L\u0003I9Wm\u001c)beF,X\r^'fi\u0006$\u0015\r^1\u0016\u0003a\u0003\"\u0001U-\n\u0005iS\"AE$f_B\u000b'/];fi6+G/\u0019#bi\u0006\f1cZ3p!\u0006\u0014\u0018/^3u\u001b\u0016$\u0018\rR1uC\u0002\"BaT/_M\")\u0001'\u0003a\u0001c!)q,\u0003a\u0001A\u0006!1m\u001c8g!\t\tG-D\u0001c\u0015\t\u0019\u0007%\u0001\u0005j]R,'O\\1m\u0013\t)'MA\u0004T#2\u001buN\u001c4\t\u000b)K\u0001\u0019A&\u0015\t=C\u0017.\u001d\u0005\u0006a)\u0001\r!\r\u0005\u0006?*\u0001\rA\u001b\t\u0003W>l\u0011\u0001\u001c\u0006\u0003?6T!A\u001c\u0013\u0002\r!\fGm\\8q\u0013\t\u0001HNA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\u0006\u0015*\u0001\raS\u0001\u0016SN$\u0016.\\3ti\u0006l\u0007O\u0014+[\u000b:\f'\r\\3e)\u0005)\u0015aB2p]Z,'\u000f\u001e\u000b\u0003mr\u0004\"a\u001e>\u000e\u0003aT!!\u001f\u0011\u0002\u000bQL\b/Z:\n\u0005mD(AC*ueV\u001cG\u000fV=qK\")Q\u0010\u0004a\u0001}\u0006i\u0001/\u0019:rk\u0016$8k\u00195f[\u0006\u00042a`A\u0004\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011AB:dQ\u0016l\u0017M\u0003\u0002\u001cI%!\u0011\u0011BA\u0001\u0005-iUm]:bO\u0016$\u0016\u0010]3\u0015\u0007Y\fi\u0001\u0003\u0004~\u001b\u0001\u0007\u0011q\u0002\t\u0004\u007f\u0006E\u0011\u0002BA\n\u0003\u0003\u0011\u0011b\u0012:pkB$\u0016\u0010]3\u0002'\r|gN^3si\u001aKW\r\u001c3XSRDw)Z8\u0015\t\u0005e\u0011q\u0004\t\u0004o\u0006m\u0011bAA\u000fq\nAA)\u0019;b)f\u0004X\rC\u0004\u0002\"9\u0001\r!a\t\u0002\u0017A\f'/];fiRK\b/\u001a\t\u0004\u007f\u0006\u0015\u0012\u0002BA\u0014\u0003\u0003\u0011A\u0001V=qK\u0006y\u0011n]$f_6,GO]=GS\u0016dG\rF\u0002F\u0003[Aa!a\f\u0010\u0001\u0004I\u0014!\u00034jK2$g*Y7f\u0003U\u0019wN\u001c<feR\u0004&/[7ji&4XMR5fY\u0012$B!!\u0007\u00026!9\u0011q\u0007\tA\u0002\u0005e\u0012!\u00024jK2$\u0007cA@\u0002<%!\u0011QHA\u0001\u00055\u0001&/[7ji&4X\rV=qK\u0006\t2m\u001c8wKJ$xI]8va\u001aKW\r\u001c3\u0015\t\u0005e\u00111\t\u0005\b\u0003o\t\u0002\u0019AA\b\u0003QI7/\u00127f[\u0016tG\u000fV=qK^KG\u000f[$f_R)Q)!\u0013\u0002N!9\u00111\n\nA\u0002\u0005\r\u0012\u0001\u0004:fa\u0016\fG/\u001a3UsB,\u0007BBA(%\u0001\u0007\u0011(\u0001\u0006qCJ,g\u000e\u001e(b[\u0016\f\u0001eR3p!\u0006\u0014\u0018/^3u)>\u001c\u0006/\u0019:l'\u000eDW-\\1D_:4XM\u001d;feB\u0011\u0001\u000bF\n\u0003))\"\"!a\u0015\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tiFK\u0002F\u0003?Z#!!\u0019\u0011\t\u0005\r\u0014QN\u0007\u0003\u0003KRA!a\u001a\u0002j\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003Wb\u0013AC1o]>$\u0018\r^5p]&!\u0011qNA3\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0001")
public class GeoParquetToSparkSchemaConverter {
    private final boolean assumeBinaryIsString;
    private final boolean assumeInt96IsTimestamp;
    private final boolean inferTimestampNTZ;
    private final GeoParquetMetaData geoParquetMetaData;

    public static boolean $lessinit$greater$default$4() {
        return GeoParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$4();
    }

    public static boolean $lessinit$greater$default$3() {
        return GeoParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean $lessinit$greater$default$2() {
        return GeoParquetToSparkSchemaConverter$.MODULE$.$lessinit$greater$default$2();
    }

    private GeoParquetMetaData geoParquetMetaData() {
        return this.geoParquetMetaData;
    }

    public boolean isTimestampNTZEnabled() {
        return this.inferTimestampNTZ;
    }

    public StructType convert(MessageType parquetSchema) {
        return this.convert(parquetSchema.asGroupType());
    }

    private StructType convert(GroupType parquetSchema) {
        Buffer fields = (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(parquetSchema.getFields()).asScala()).map((Function1 & Serializable)field -> {
            Type.Repetition repetition = field.getRepetition();
            if (Type.Repetition.OPTIONAL.equals(repetition)) {
                return new StructField(field.getName(), this.convertFieldWithGeo((Type)field), true, StructField$.MODULE$.apply$default$4());
            }
            if (Type.Repetition.REQUIRED.equals(repetition)) {
                return new StructField(field.getName(), this.convertFieldWithGeo((Type)field), false, StructField$.MODULE$.apply$default$4());
            }
            if (Type.Repetition.REPEATED.equals(repetition)) {
                ArrayType arrayType = new ArrayType(this.convertFieldWithGeo((Type)field), false);
                return new StructField(field.getName(), (DataType)arrayType, false, StructField$.MODULE$.apply$default$4());
            }
            throw new MatchError((Object)repetition);
        });
        return StructType$.MODULE$.apply(fields.toSeq());
    }

    public DataType convertFieldWithGeo(Type parquetType) {
        Type type = parquetType;
        if (type instanceof PrimitiveType) {
            PrimitiveType primitiveType = (PrimitiveType)type;
            return this.convertPrimitiveField(primitiveType);
        }
        if (type instanceof GroupType) {
            GroupType groupType = (GroupType)type;
            return this.convertGroupField(groupType.asGroupType());
        }
        throw new MatchError((Object)type);
    }

    private boolean isGeometryField(String fieldName) {
        return this.geoParquetMetaData().columns().contains((Object)fieldName);
    }

    private DataType convertPrimitiveField(PrimitiveType field) {
        PrimitiveType.PrimitiveTypeName typeName = field.getPrimitiveTypeName();
        OriginalType originalType = field.getOriginalType();
        PrimitiveType.PrimitiveTypeName primitiveTypeName = typeName;
        if (PrimitiveType.PrimitiveTypeName.BOOLEAN.equals(primitiveTypeName)) {
            return BooleanType$.MODULE$;
        }
        if (PrimitiveType.PrimitiveTypeName.FLOAT.equals(primitiveTypeName)) {
            return FloatType$.MODULE$;
        }
        if (PrimitiveType.PrimitiveTypeName.DOUBLE.equals(primitiveTypeName)) {
            return DoubleType$.MODULE$;
        }
        if (PrimitiveType.PrimitiveTypeName.INT32.equals(primitiveTypeName)) {
            OriginalType originalType2 = originalType;
            if (OriginalType.INT_8.equals(originalType2)) {
                return ByteType$.MODULE$;
            }
            if (OriginalType.INT_16.equals(originalType2)) {
                return ShortType$.MODULE$;
            }
            if (OriginalType.INT_32.equals(originalType2) ? true : originalType2 == null) {
                return IntegerType$.MODULE$;
            }
            if (OriginalType.DATE.equals(originalType2)) {
                return DateType$.MODULE$;
            }
            if (OriginalType.DECIMAL.equals(originalType2)) {
                return GeoParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.MAX_INT_DIGITS(), field, typeName);
            }
            if (OriginalType.UINT_8.equals(originalType2)) {
                throw GeoParquetToSparkSchemaConverter.typeNotSupported$1(originalType, typeName);
            }
            if (OriginalType.UINT_16.equals(originalType2)) {
                throw GeoParquetToSparkSchemaConverter.typeNotSupported$1(originalType, typeName);
            }
            if (OriginalType.UINT_32.equals(originalType2)) {
                throw GeoParquetToSparkSchemaConverter.typeNotSupported$1(originalType, typeName);
            }
            if (OriginalType.TIME_MILLIS.equals(originalType2)) {
                throw GeoParquetToSparkSchemaConverter.typeNotImplemented$1(originalType, typeName);
            }
            throw GeoParquetToSparkSchemaConverter.illegalType$1(originalType, typeName);
        }
        if (PrimitiveType.PrimitiveTypeName.INT64.equals(primitiveTypeName)) {
            OriginalType originalType3 = originalType;
            if (OriginalType.INT_64.equals(originalType3) ? true : originalType3 == null) {
                return LongType$.MODULE$;
            }
            if (OriginalType.DECIMAL.equals(originalType3)) {
                return GeoParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.MAX_LONG_DIGITS(), field, typeName);
            }
            if (OriginalType.UINT_64.equals(originalType3)) {
                throw GeoParquetToSparkSchemaConverter.typeNotSupported$1(originalType, typeName);
            }
            if (OriginalType.TIMESTAMP_MICROS.equals(originalType3)) {
                return TimestampType$.MODULE$;
            }
            if (OriginalType.TIMESTAMP_MILLIS.equals(originalType3)) {
                return TimestampType$.MODULE$;
            }
            throw GeoParquetToSparkSchemaConverter.illegalType$1(originalType, typeName);
        }
        if (PrimitiveType.PrimitiveTypeName.INT96.equals(primitiveTypeName)) {
            ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0)(JFunction0.mcZ.sp & Serializable)() -> $this.assumeInt96IsTimestamp, new StringBuilder(88).append("INT96 is not supported unless it's interpreted as timestamp. ").append("Please try to set ").append(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key()).append(" to true.").toString());
            return TimestampType$.MODULE$;
        }
        if (PrimitiveType.PrimitiveTypeName.BINARY.equals(primitiveTypeName)) {
            boolean bl = false;
            OriginalType originalType4 = null;
            OriginalType originalType5 = originalType;
            if (OriginalType.UTF8.equals(originalType5) ? true : (OriginalType.ENUM.equals(originalType5) ? true : OriginalType.JSON.equals(originalType5))) {
                return StringType$.MODULE$;
            }
            if (originalType5 == null) {
                bl = true;
                originalType4 = originalType5;
                if (this.isGeometryField(field.getName())) {
                    return GeometryUDT$.MODULE$;
                }
            }
            if (bl && this.assumeBinaryIsString) {
                return StringType$.MODULE$;
            }
            if (bl) {
                return BinaryType$.MODULE$;
            }
            if (OriginalType.BSON.equals(originalType5)) {
                return BinaryType$.MODULE$;
            }
            if (OriginalType.DECIMAL.equals(originalType5)) {
                return GeoParquetToSparkSchemaConverter.makeDecimalType$1(GeoParquetToSparkSchemaConverter.makeDecimalType$default$1$1(), field, typeName);
            }
            throw GeoParquetToSparkSchemaConverter.illegalType$1(originalType, typeName);
        }
        if (PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY.equals(primitiveTypeName)) {
            OriginalType originalType6 = originalType;
            if (OriginalType.DECIMAL.equals(originalType6)) {
                return GeoParquetToSparkSchemaConverter.makeDecimalType$1(Decimal$.MODULE$.maxPrecisionForBytes(field.getTypeLength()), field, typeName);
            }
            if (OriginalType.INTERVAL.equals(originalType6)) {
                throw GeoParquetToSparkSchemaConverter.typeNotImplemented$1(originalType, typeName);
            }
            throw GeoParquetToSparkSchemaConverter.illegalType$1(originalType, typeName);
        }
        throw GeoParquetToSparkSchemaConverter.illegalType$1(originalType, typeName);
    }

    private DataType convertGroupField(GroupType field) {
        return (DataType)Option$.MODULE$.apply((Object)field.getOriginalType()).fold((Function0 & Serializable)() -> this.convert(field), (Function1 & Serializable)x0$1 -> {
            OriginalType originalType = x0$1;
            if (OriginalType.LIST.equals(originalType)) {
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0)(JFunction0.mcZ.sp & Serializable)() -> field.getFieldCount() == 1, new StringBuilder(18).append("Invalid list type ").append(field).toString());
                Type repeatedType = field.getType(0);
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0)(JFunction0.mcZ.sp & Serializable)() -> repeatedType.isRepetition(Type.Repetition.REPEATED), new StringBuilder(18).append("Invalid list type ").append(field).toString());
                if (this.isElementTypeWithGeo(repeatedType, field.getName())) {
                    return new ArrayType(this.convertFieldWithGeo(repeatedType), false);
                }
                Type elementType = repeatedType.asGroupType().getType(0);
                boolean optional = elementType.isRepetition(Type.Repetition.OPTIONAL);
                return new ArrayType(this.convertFieldWithGeo(elementType), optional);
            }
            if (OriginalType.MAP.equals(originalType) ? true : OriginalType.MAP_KEY_VALUE.equals(originalType)) {
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0)(JFunction0.mcZ.sp & Serializable)() -> field.getFieldCount() == 1 && !field.getType(0).isPrimitive(), new StringBuilder(18).append("Invalid map type: ").append(field).toString());
                GroupType keyValueType = field.getType(0).asGroupType();
                ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0)(JFunction0.mcZ.sp & Serializable)() -> keyValueType.isRepetition(Type.Repetition.REPEATED) && keyValueType.getFieldCount() == 2, new StringBuilder(18).append("Invalid map type: ").append(field).toString());
                Type keyType = keyValueType.getType(0);
                Type valueType = keyValueType.getType(1);
                boolean valueOptional = valueType.isRepetition(Type.Repetition.OPTIONAL);
                return new MapType(this.convertFieldWithGeo(keyType), this.convertFieldWithGeo(valueType), valueOptional);
            }
            throw new IllegalArgumentException(new StringBuilder(27).append("Unrecognized Parquet type: ").append(field).toString());
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isElementTypeWithGeo(Type repeatedType, String parentName) {
        if (repeatedType.isPrimitive()) return true;
        if (repeatedType.asGroupType().getFieldCount() > 1) return true;
        String string = repeatedType.getName();
        String string2 = "array";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = repeatedType.getName();
        String string4 = new StringBuilder(6).append(parentName).append("_tuple").toString();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    private static final String typeString$1(OriginalType originalType$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        if (originalType$1 == null) {
            return String.valueOf(typeName$1);
        }
        return new StringBuilder(3).append(typeName$1).append(" (").append(originalType$1).append(")").toString();
    }

    private static final Nothing$ typeNotSupported$1(OriginalType originalType$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw new IllegalArgumentException(new StringBuilder(28).append("Parquet type not supported: ").append(GeoParquetToSparkSchemaConverter.typeString$1(originalType$1, typeName$1)).toString());
    }

    private static final Nothing$ typeNotImplemented$1(OriginalType originalType$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw new IllegalArgumentException(new StringBuilder(32).append("Parquet type not yet supported: ").append(GeoParquetToSparkSchemaConverter.typeString$1(originalType$1, typeName$1)).toString());
    }

    private static final Nothing$ illegalType$1(OriginalType originalType$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        throw new IllegalArgumentException(new StringBuilder(22).append("Illegal Parquet type: ").append(GeoParquetToSparkSchemaConverter.typeString$1(originalType$1, typeName$1)).toString());
    }

    private static final DecimalType makeDecimalType$1(int maxPrecision, PrimitiveType field$1, PrimitiveType.PrimitiveTypeName typeName$1) {
        int precision = field$1.getDecimalMetadata().getPrecision();
        int scale = field$1.getDecimalMetadata().getScale();
        ParquetSchemaConverter$.MODULE$.checkConversionRequirement((Function0)(JFunction0.mcZ.sp & Serializable)() -> maxPrecision == -1 || 1 <= precision && precision <= maxPrecision, new StringBuilder(55).append("Invalid decimal precision: ").append(typeName$1).append(" cannot store ").append(precision).append(" digits (max ").append(maxPrecision).append(")").toString());
        return new DecimalType(precision, scale);
    }

    private static final int makeDecimalType$default$1$1() {
        return -1;
    }

    public GeoParquetToSparkSchemaConverter(Map<String, String> keyValueMetaData, boolean assumeBinaryIsString, boolean assumeInt96IsTimestamp, boolean inferTimestampNTZ, scala.collection.immutable.Map<String, String> parameters) {
        this.assumeBinaryIsString = assumeBinaryIsString;
        this.assumeInt96IsTimestamp = assumeInt96IsTimestamp;
        this.inferTimestampNTZ = inferTimestampNTZ;
        this.geoParquetMetaData = GeoParquetUtils$.MODULE$.parseGeoParquetMetaData(keyValueMetaData, parameters);
    }

    public GeoParquetToSparkSchemaConverter(Map<String, String> keyValueMetaData, SQLConf conf, scala.collection.immutable.Map<String, String> parameters) {
        this(keyValueMetaData, conf.isParquetBinaryAsString(), conf.isParquetINT96AsTimestamp(), conf.parquetInferTimestampNTZEnabled(), parameters);
    }

    public GeoParquetToSparkSchemaConverter(Map<String, String> keyValueMetaData, Configuration conf, scala.collection.immutable.Map<String, String> parameters) {
        this(keyValueMetaData, StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key()))), StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key()))), StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(conf.get(SQLConf$.MODULE$.PARQUET_INFER_TIMESTAMP_NTZ_ENABLED().key()))), parameters);
    }
}

