/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.StringTokenizer;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImmutable;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonPoints;
import ucar.unidata.util.Format;

public class LatLonRect {
    public static LatLonRect INVALID = new LatLonRect(LatLonPointImmutable.INVALID, LatLonPointImmutable.INVALID);
    private LatLonPointImpl upperRight;
    private LatLonPointImpl lowerLeft;
    private boolean crossDateline;
    private boolean allLongitude;
    private double width;
    private double lon0;

    public LatLonRect(LatLonPoint p1, double deltaLat, double deltaLon) {
        this.init(p1, deltaLat, deltaLon);
    }

    private void init(LatLonPoint p1, double deltaLat, double deltaLon) {
        double lonmax;
        double lonmin;
        double latmin = Math.min(p1.getLatitude(), p1.getLatitude() + deltaLat);
        double latmax = Math.max(p1.getLatitude(), p1.getLatitude() + deltaLat);
        double lonpt = p1.getLongitude();
        if (deltaLon > 0.0) {
            lonmin = lonpt;
            lonmax = lonpt + deltaLon;
            this.crossDateline = lonmax > 180.0;
        } else {
            lonmax = lonpt;
            lonmin = lonpt + deltaLon;
            this.crossDateline = lonmin < -180.0;
        }
        this.lowerLeft = new LatLonPointImpl(latmin, lonmin);
        this.upperRight = new LatLonPointImpl(latmax, lonmax);
        this.width = Math.abs(deltaLon);
        this.lon0 = LatLonPoints.lonNormal(p1.getLongitude() + deltaLon / 2.0);
        this.allLongitude = this.width >= 360.0;
    }

    public LatLonRect(LatLonPoint left, LatLonPoint right) {
        this(left, right.getLatitude() - left.getLatitude(), LatLonPoints.lonNormal360(right.getLongitude() - left.getLongitude()));
    }

    public LatLonRect(String spec) {
        StringTokenizer stoker = new StringTokenizer(spec, " ,");
        int n = stoker.countTokens();
        if (n != 4) {
            throw new IllegalArgumentException("Must be 4 numbers = lat, lon, latWidth, lonWidth");
        }
        double lat = Double.parseDouble(stoker.nextToken());
        double lon = Double.parseDouble(stoker.nextToken());
        double deltaLat = Double.parseDouble(stoker.nextToken());
        double deltaLon = Double.parseDouble(stoker.nextToken());
        this.init(LatLonPoint.create(lat, lon), deltaLat, deltaLon);
    }

    public LatLonRect(LatLonRect r) {
        this(r.getLowerLeftPoint(), r.getUpperRightPoint().getLatitude() - r.getLowerLeftPoint().getLatitude(), r.getWidth());
    }

    public LatLonRect() {
        this(LatLonPoint.create(-90.0, -180.0), 180.0, 360.0);
    }

    public LatLonPointImpl getUpperRightPoint() {
        return this.upperRight;
    }

    public LatLonPointImpl getLowerLeftPoint() {
        return this.lowerLeft;
    }

    public LatLonPointImpl getUpperLeftPoint() {
        return new LatLonPointImpl(this.upperRight.getLatitude(), this.lowerLeft.getLongitude());
    }

    public LatLonPointImpl getLowerRightPoint() {
        return new LatLonPointImpl(this.lowerLeft.getLatitude(), this.upperRight.getLongitude());
    }

    public boolean crossDateline() {
        return this.crossDateline;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LatLonRect that = (LatLonRect)o;
        return Objects.equals(this.upperRight, that.upperRight) && Objects.equals(this.lowerLeft, that.lowerLeft);
    }

    public int hashCode() {
        return Objects.hash(this.upperRight, this.lowerLeft);
    }

    public boolean nearlyEquals(LatLonRect other) {
        return this.nearlyEquals(other, 1.0E-5f);
    }

    public boolean nearlyEquals(LatLonRect other, double maxRelDiff) {
        return this.getLowerLeftPoint().nearlyEquals(other.getLowerLeftPoint(), maxRelDiff) && this.getUpperRightPoint().nearlyEquals(other.getUpperRightPoint(), maxRelDiff);
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.getLatMax() - this.getLatMin();
    }

    public double getCenterLon() {
        return this.lon0;
    }

    public double getLonMin() {
        return this.lowerLeft.getLongitude();
    }

    public double getLonMax() {
        return this.lowerLeft.getLongitude() + this.width;
    }

    public double getLatMin() {
        return this.lowerLeft.getLatitude();
    }

    public double getLatMax() {
        return this.upperRight.getLatitude();
    }

    public boolean contains(LatLonPoint p) {
        return this.contains(p.getLatitude(), p.getLongitude());
    }

    public boolean contains(double lat, double lon) {
        double eps = 1.0E-9;
        if (lat + eps < this.lowerLeft.getLatitude() || lat - eps > this.upperRight.getLatitude()) {
            return false;
        }
        if (this.allLongitude) {
            return true;
        }
        if (this.crossDateline) {
            return lon >= this.lowerLeft.getLongitude() || lon <= this.upperRight.getLongitude();
        }
        return lon >= this.lowerLeft.getLongitude() && lon <= this.upperRight.getLongitude();
    }

    public boolean containedIn(LatLonRect b) {
        return b.getWidth() >= this.width && b.contains(this.upperRight) && b.contains(this.lowerLeft);
    }

    public static LatLonRect extend(LatLonRect rect, LatLonPoint p) {
        LatLonRect copy = new LatLonRect(rect);
        copy.extend(p);
        return copy;
    }

    public static LatLonRect extend(LatLonRect rect, LatLonRect other) {
        LatLonRect copy = new LatLonRect(rect);
        copy.extend(other);
        return copy;
    }

    @Deprecated
    public void extend(LatLonPoint p) {
        if (this.contains(p)) {
            return;
        }
        double lat = p.getLatitude();
        double lon = p.getLongitude();
        if (lat > this.upperRight.getLatitude()) {
            this.upperRight.setLatitude(lat);
        }
        if (lat < this.lowerLeft.getLatitude()) {
            this.lowerLeft.setLatitude(lat);
        }
        if (!this.allLongitude) {
            if (this.crossDateline) {
                double d1 = lon - this.upperRight.getLongitude();
                double d2 = this.lowerLeft.getLongitude() - lon;
                if (d1 > 0.0 && d2 > 0.0) {
                    if (d1 > d2) {
                        this.lowerLeft.setLongitude(lon);
                    } else {
                        this.upperRight.setLongitude(lon);
                    }
                }
            } else if (lon > this.upperRight.getLongitude()) {
                if (lon - this.upperRight.getLongitude() > this.lowerLeft.getLongitude() - lon + 360.0) {
                    this.crossDateline = true;
                    this.lowerLeft.setLongitude(lon);
                } else {
                    this.upperRight.setLongitude(lon);
                }
            } else if (lon < this.lowerLeft.getLongitude()) {
                if (this.lowerLeft.getLongitude() - lon > lon + 360.0 - this.upperRight.getLongitude()) {
                    this.crossDateline = true;
                    this.upperRight.setLongitude(lon);
                } else {
                    this.lowerLeft.setLongitude(lon);
                }
            }
        }
        this.width = this.upperRight.getLongitude() - this.lowerLeft.getLongitude();
        this.lon0 = (this.upperRight.getLongitude() + this.lowerLeft.getLongitude()) / 2.0;
        if (this.crossDateline) {
            this.width += 360.0;
            this.lon0 -= 180.0;
        }
        this.allLongitude = this.allLongitude || this.width >= 360.0;
    }

    @Deprecated
    public void extend(LatLonRect r) {
        Preconditions.checkNotNull(r);
        double latMin = r.getLatMin();
        double latMax = r.getLatMax();
        if (latMax > this.upperRight.getLatitude()) {
            this.upperRight.setLatitude(latMax);
        }
        if (latMin < this.lowerLeft.getLatitude()) {
            this.lowerLeft.setLatitude(latMin);
        }
        if (this.allLongitude) {
            return;
        }
        double lonMin = this.getLonMin();
        double lonMax = this.getLonMax();
        double nlonMin = LatLonPoints.lonNormal(r.getLonMin(), lonMin);
        double nlonMax = nlonMin + r.getWidth();
        lonMin = Math.min(lonMin, nlonMin);
        lonMax = Math.max(lonMax, nlonMax);
        this.width = lonMax - lonMin;
        boolean bl = this.allLongitude = this.width >= 360.0;
        if (this.allLongitude) {
            this.width = 360.0;
            lonMin = -180.0;
        } else {
            lonMin = LatLonPoints.lonNormal(lonMin);
        }
        this.lowerLeft.setLongitude(lonMin);
        this.upperRight.setLongitude(lonMin + this.width);
        this.lon0 = lonMin + this.width / 2.0;
        this.crossDateline = this.lowerLeft.getLongitude() > this.upperRight.getLongitude();
    }

    public LatLonRect intersect(LatLonRect clip) {
        double lon2max;
        double lon2min;
        double lon1max;
        double latMin = Math.max(this.getLatMin(), clip.getLatMin());
        double latMax = Math.min(this.getLatMax(), clip.getLatMax());
        double deltaLat = latMax - latMin;
        if (deltaLat < 0.0) {
            return null;
        }
        double lon1min = this.getLonMin();
        if (!this.intersect(lon1min, lon1max = this.getLonMax(), lon2min = clip.getLonMin(), lon2max = clip.getLonMax()) && !this.intersect(lon1min, lon1max, lon2min = clip.getLonMin() + 360.0, lon2max = clip.getLonMax() + 360.0)) {
            lon2min = clip.getLonMin() - 360.0;
            lon2max = clip.getLonMax() - 360.0;
        }
        double lonMin = Math.max(lon1min, lon2min);
        double lonMax = Math.min(lon1max, lon2max);
        double deltaLon = lonMax - lonMin;
        if (deltaLon < 0.0) {
            return null;
        }
        return new LatLonRect(LatLonPoint.create(latMin, lonMin), deltaLat, deltaLon);
    }

    private boolean intersect(double min1, double max1, double min2, double max2) {
        double max;
        double min3 = Math.max(min1, min2);
        return min3 < (max = Math.min(max1, max2));
    }

    public String toString() {
        return " ll: " + this.lowerLeft + "+ ur: " + this.upperRight;
    }

    public String toString2() {
        return " lat= [" + Format.dfrac(this.getLatMin(), 2) + "," + Format.dfrac(this.getLatMax(), 2) + "] lon= [" + Format.dfrac(this.getLonMin(), 2) + "," + Format.dfrac(this.getLonMax(), 2) + "]";
    }
}

