/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.snowflake.snowsql.ddl;

import java.util.HashMap;
import java.util.Map;
import org.apache.sedona.snowflake.snowsql.ddl.Constants;
import org.apache.sedona.snowflake.snowsql.ddl.UDFDDLGenerator;
import org.apache.sedona.snowflake.snowsql.ddl.UDTFDDLGenerator;

public class DDLGenerator {
    public static Map<String, String> parseArgs(String[] args) {
        HashMap<String, String> argMap = new HashMap<String, String>();
        if (args.length == 0) {
            DDLGenerator.printUsage();
            System.exit(0);
        }
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-h")) {
                DDLGenerator.printUsage();
                System.exit(0);
            }
            if (!arg.startsWith("--")) continue;
            String argName = arg.substring(2).replace("-", "_");
            String argValue = args[++i];
            argMap.put(argName, argValue);
        }
        argMap.put(Constants.SEDONA_VERSION, DDLGenerator.class.getPackage().getImplementationVersion() == null ? "unknown" : DDLGenerator.class.getPackage().getImplementationVersion());
        try {
            assert (argMap.containsKey(Constants.GEOTOOLS_VERSION));
        }
        catch (AssertionError e) {
            System.out.println("Missing required arguments");
            DDLGenerator.printUsage();
        }
        return argMap;
    }

    public static void printUsage() {
        System.out.println("Usage: java -jar snowflake/target/sedona-snowflake-1.5.1.jar [options]");
        System.out.println("Must have Arguments");
        System.out.println("  --geotools-version <version>");
        System.out.println("Optional have Arguments");
        System.out.println("  --schema <schema>  register functions to this schema. Default to sedona");
        System.out.println("  --stageName <stageName>  snowflake stage name to upload jar files. Not needed if isNativeApp is true");
        System.out.println("  --isNativeApp <true/false>  whether to generate DDL for Snowflake Native App. Default to false");
        System.out.println("  --appRoleName <appRoleName>  application role name. Required when isNativeApp is true. Default to app_public");
        System.out.println("  --h  Print this help message");
        System.exit(0);
    }

    public static void main(String[] args) {
        String stageName;
        String appRoleName;
        boolean isNativeApp;
        Map<String, String> argMap = DDLGenerator.parseArgs(args);
        if (argMap.getOrDefault("isNativeApp", "false").equals("true")) {
            isNativeApp = true;
            argMap.put("stageName", "");
            appRoleName = argMap.getOrDefault("appRoleName", "app_public");
            if (!argMap.containsKey("appRoleName")) {
                System.out.println("-- AppRoleName is required when isNativeApp is true. If not provided, default to app_public");
            }
            stageName = "";
            System.out.println("-- Generating DDL for Snowflake Native App");
            System.out.println("CREATE APPLICATION ROLE IF NOT EXISTS " + appRoleName + ";");
            System.out.println("CREATE OR ALTER VERSIONED SCHEMA sedona;");
            System.out.println("GRANT USAGE ON SCHEMA sedona TO APPLICATION ROLE " + appRoleName + ";");
        } else {
            isNativeApp = false;
            appRoleName = "";
            System.out.println("-- IsNativeApp is false. Generating DDL for User-Managed Snowflake Account");
            stageName = argMap.getOrDefault("stageName", "@ApacheSedona");
            if (!stageName.startsWith("@")) {
                System.out.println("-- StageName must start with @");
                System.exit(0);
            }
        }
        try {
            System.out.println("-- UDFs --");
            System.out.println(String.join((CharSequence)"\n", UDFDDLGenerator.buildAll(argMap, stageName, isNativeApp, appRoleName)));
            System.out.println("-- UDTFs --");
            System.out.println(String.join((CharSequence)"\n", UDTFDDLGenerator.buildAll(argMap, stageName, isNativeApp, appRoleName)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

