/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.relateng;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateArrays;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.noding.BasicSegmentString;
import org.locationtech.jts.operation.relateng.NodeSection;
import org.locationtech.jts.operation.relateng.RelateGeometry;

class RelateSegmentString
extends BasicSegmentString {
    private boolean isA;
    private int dimension;
    private int id;
    private int ringId;
    private RelateGeometry inputGeom;
    private Geometry parentPolygonal = null;

    public static RelateSegmentString createLine(Coordinate[] pts, boolean isA, int elementId, RelateGeometry parent) {
        return RelateSegmentString.createSegmentString(pts, isA, 1, elementId, -1, null, parent);
    }

    public static RelateSegmentString createRing(Coordinate[] pts, boolean isA, int elementId, int ringId, Geometry poly, RelateGeometry parent) {
        return RelateSegmentString.createSegmentString(pts, isA, 2, elementId, ringId, poly, parent);
    }

    private static RelateSegmentString createSegmentString(Coordinate[] pts, boolean isA, int dim, int elementId, int ringId, Geometry poly, RelateGeometry parent) {
        pts = RelateSegmentString.removeRepeatedPoints(pts);
        return new RelateSegmentString(pts, isA, dim, elementId, ringId, poly, parent);
    }

    private static Coordinate[] removeRepeatedPoints(Coordinate[] pts) {
        if (CoordinateArrays.hasRepeatedPoints(pts)) {
            pts = CoordinateArrays.removeRepeatedPoints(pts);
        }
        return pts;
    }

    private RelateSegmentString(Coordinate[] pts, boolean isA, int dimension, int id, int ringId, Geometry poly, RelateGeometry inputGeom) {
        super(pts, null);
        this.isA = isA;
        this.dimension = dimension;
        this.id = id;
        this.ringId = ringId;
        this.parentPolygonal = poly;
        this.inputGeom = inputGeom;
    }

    public boolean isA() {
        return this.isA;
    }

    public RelateGeometry getGeometry() {
        return this.inputGeom;
    }

    public Geometry getPolygonal() {
        return this.parentPolygonal;
    }

    public NodeSection createNodeSection(int segIndex, Coordinate intPt) {
        boolean isNodeAtVertex = intPt.equals2D(this.getCoordinate(segIndex)) || intPt.equals2D(this.getCoordinate(segIndex + 1));
        Coordinate prev = this.prevVertex(segIndex, intPt);
        Coordinate next = this.nextVertex(segIndex, intPt);
        NodeSection a = new NodeSection(this.isA, this.dimension, this.id, this.ringId, this.parentPolygonal, isNodeAtVertex, prev, intPt, next);
        return a;
    }

    private Coordinate prevVertex(int segIndex, Coordinate pt) {
        Coordinate segStart = this.getCoordinate(segIndex);
        if (!segStart.equals2D(pt)) {
            return segStart;
        }
        if (segIndex > 0) {
            return this.getCoordinate(segIndex - 1);
        }
        if (this.isClosed()) {
            return this.prevInRing(segIndex);
        }
        return null;
    }

    private Coordinate nextVertex(int segIndex, Coordinate pt) {
        Coordinate segEnd = this.getCoordinate(segIndex + 1);
        if (!segEnd.equals2D(pt)) {
            return segEnd;
        }
        if (segIndex < this.size() - 2) {
            return this.getCoordinate(segIndex + 2);
        }
        if (this.isClosed()) {
            return this.nextInRing(segIndex + 1);
        }
        return null;
    }

    public boolean isContainingSegment(int segIndex, Coordinate pt) {
        if (pt.equals2D(this.getCoordinate(segIndex))) {
            return true;
        }
        if (pt.equals2D(this.getCoordinate(segIndex + 1))) {
            boolean isFinalSegment;
            boolean bl = isFinalSegment = segIndex == this.size() - 2;
            return !this.isClosed() && isFinalSegment;
        }
        return true;
    }
}

