export interface ExposedBinderInstance {
    targetRef: HTMLElement | null;
}
export interface BinderInstance extends ExposedBinderInstance {
    syncTargetWithParent: boolean;
    syncTarget: boolean;
    setTargetRef: (el: HTMLElement | null) => void;
    addScrollListener: (listener: () => void) => void;
    removeScrollListener: (listener: () => void) => void;
    addResizeListener: (listener: () => void) => void;
    removeResizeListener: (listener: () => void) => void;
}
export declare type Placement = 'top' | 'bottom' | 'left' | 'right' | 'top-start' | 'top-end' | 'left-start' | 'left-end' | 'right-start' | 'right-end' | 'bottom-start' | 'bottom-end';
export declare type NonCenterPlacement = 'top-start' | 'top-end' | 'left-start' | 'left-end' | 'right-start' | 'right-end' | 'bottom-start' | 'bottom-end';
export interface Rect {
    left: number;
    right: number;
    top: number;
    bottom: number;
    width: number;
    height: number;
}
export declare type Align = 'start' | 'end' | 'center';
export declare type Position = 'left' | 'right' | 'top' | 'bottom';
export declare type TransformOrigin = 'top left' | 'top center' | 'top right' | 'bottom left' | 'bottom center' | 'bottom right' | 'top left' | 'center left' | 'bottom left' | 'top right' | 'center right' | 'bottom right';
export declare type FlipLevel = 1 | 2;
