/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.proxy.service.receipt;

import com.google.common.base.Stopwatch;
import io.netty.channel.Channel;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.broker.client.ClientChannelInfo;
import org.apache.rocketmq.broker.client.ConsumerGroupEvent;
import org.apache.rocketmq.broker.client.ConsumerIdsChangeListener;
import org.apache.rocketmq.broker.client.ConsumerManager;
import org.apache.rocketmq.client.consumer.AckResult;
import org.apache.rocketmq.client.consumer.AckStatus;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.consumer.ReceiptHandle;
import org.apache.rocketmq.common.state.StateEventListener;
import org.apache.rocketmq.common.thread.ThreadPoolMonitor;
import org.apache.rocketmq.common.utils.AbstractStartAndShutdown;
import org.apache.rocketmq.common.utils.ConcurrentHashMapUtils;
import org.apache.rocketmq.common.utils.ExceptionUtils;
import org.apache.rocketmq.common.utils.StartAndShutdown;
import org.apache.rocketmq.common.utils.ThreadUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.proxy.common.MessageReceiptHandle;
import org.apache.rocketmq.proxy.common.ProxyContext;
import org.apache.rocketmq.proxy.common.ProxyException;
import org.apache.rocketmq.proxy.common.ProxyExceptionCode;
import org.apache.rocketmq.proxy.common.ReceiptHandleGroup;
import org.apache.rocketmq.proxy.common.ReceiptHandleGroupKey;
import org.apache.rocketmq.proxy.common.RenewEvent;
import org.apache.rocketmq.proxy.common.RenewStrategyPolicy;
import org.apache.rocketmq.proxy.common.channel.ChannelHelper;
import org.apache.rocketmq.proxy.config.ConfigurationManager;
import org.apache.rocketmq.proxy.config.ProxyConfig;
import org.apache.rocketmq.proxy.service.metadata.MetadataService;
import org.apache.rocketmq.proxy.service.receipt.ReceiptHandleManager;
import org.apache.rocketmq.remoting.protocol.subscription.RetryPolicy;
import org.apache.rocketmq.remoting.protocol.subscription.SubscriptionGroupConfig;

public class DefaultReceiptHandleManager
extends AbstractStartAndShutdown
implements ReceiptHandleManager {
    protected static final Logger log = LoggerFactory.getLogger((String)"RocketmqProxy");
    protected final MetadataService metadataService;
    protected final ConsumerManager consumerManager;
    protected final ConcurrentMap<ReceiptHandleGroupKey, ReceiptHandleGroup> receiptHandleGroupMap;
    protected final StateEventListener<RenewEvent> eventListener;
    protected static final RetryPolicy RENEW_POLICY = new RenewStrategyPolicy();
    protected final ScheduledExecutorService scheduledExecutorService = ThreadUtils.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl("RenewalScheduledThread_"));
    protected final ThreadPoolExecutor renewalWorkerService;
    protected final ThreadPoolExecutor returnHandleGroupWorkerService;

    public DefaultReceiptHandleManager(MetadataService metadataService, ConsumerManager consumerManager, StateEventListener<RenewEvent> eventListener) {
        this.metadataService = metadataService;
        this.consumerManager = consumerManager;
        this.eventListener = eventListener;
        ProxyConfig proxyConfig = ConfigurationManager.getProxyConfig();
        this.renewalWorkerService = ThreadPoolMonitor.createAndMonitor((int)proxyConfig.getRenewThreadPoolNums(), (int)proxyConfig.getRenewMaxThreadPoolNums(), (long)1L, (TimeUnit)TimeUnit.MINUTES, (String)"RenewalWorkerThread", (int)proxyConfig.getRenewThreadPoolQueueCapacity());
        this.returnHandleGroupWorkerService = ThreadPoolMonitor.createAndMonitor((int)proxyConfig.getReturnHandleGroupThreadPoolNums(), (int)(proxyConfig.getReturnHandleGroupThreadPoolNums() * 2), (long)1L, (TimeUnit)TimeUnit.MINUTES, (String)"ReturnHandleGroupWorkerThread", (int)proxyConfig.getRenewThreadPoolQueueCapacity());
        consumerManager.appendConsumerIdsChangeListener(new ConsumerIdsChangeListener(){

            public void handle(ConsumerGroupEvent event, String group, Object ... args) {
                if (ConsumerGroupEvent.CLIENT_UNREGISTER.equals((Object)event)) {
                    if (args == null || args.length < 1) {
                        return;
                    }
                    if (args[0] instanceof ClientChannelInfo) {
                        ClientChannelInfo clientChannelInfo = (ClientChannelInfo)args[0];
                        if (ChannelHelper.isRemote(clientChannelInfo.getChannel())) {
                            return;
                        }
                        DefaultReceiptHandleManager.this.clearGroup(new ReceiptHandleGroupKey(clientChannelInfo.getChannel(), group));
                        log.info("clear handle of this client when client unregister. group:{}, clientChannelInfo:{}", (Object)group, (Object)clientChannelInfo);
                    }
                }
            }

            public void shutdown() {
            }
        });
        this.receiptHandleGroupMap = new ConcurrentHashMap<ReceiptHandleGroupKey, ReceiptHandleGroup>();
        this.renewalWorkerService.setRejectedExecutionHandler((r, executor) -> log.warn("add renew task failed. queueSize:{}", (Object)executor.getQueue().size()));
        this.appendStartAndShutdown(new StartAndShutdown(){

            public void start() throws Exception {
                DefaultReceiptHandleManager.this.scheduledExecutorService.scheduleWithFixedDelay(() -> DefaultReceiptHandleManager.this.scheduleRenewTask(), 0L, ConfigurationManager.getProxyConfig().getRenewSchedulePeriodMillis(), TimeUnit.MILLISECONDS);
            }

            public void shutdown() throws Exception {
                DefaultReceiptHandleManager.this.scheduledExecutorService.shutdown();
                DefaultReceiptHandleManager.this.clearAllHandle();
            }
        });
    }

    @Override
    public void addReceiptHandle(ProxyContext context, Channel channel, String group, String msgID, MessageReceiptHandle messageReceiptHandle) {
        ((ReceiptHandleGroup)ConcurrentHashMapUtils.computeIfAbsent(this.receiptHandleGroupMap, (Object)new ReceiptHandleGroupKey(channel, group), k -> new ReceiptHandleGroup())).put(msgID, messageReceiptHandle);
    }

    @Override
    public MessageReceiptHandle removeReceiptHandle(ProxyContext context, Channel channel, String group, String msgID, String receiptHandle) {
        ReceiptHandleGroup handleGroup = (ReceiptHandleGroup)this.receiptHandleGroupMap.get(new ReceiptHandleGroupKey(channel, group));
        if (handleGroup == null) {
            return null;
        }
        return handleGroup.remove(msgID, receiptHandle);
    }

    protected boolean clientIsOffline(ReceiptHandleGroupKey groupKey) {
        return this.consumerManager.findChannel(groupKey.getGroup(), groupKey.getChannel()) == null;
    }

    protected void scheduleRenewTask() {
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            ProxyConfig proxyConfig = ConfigurationManager.getProxyConfig();
            for (Map.Entry entry : this.receiptHandleGroupMap.entrySet()) {
                ReceiptHandleGroupKey key = (ReceiptHandleGroupKey)entry.getKey();
                if (this.clientIsOffline(key)) {
                    this.clearGroup(key);
                    continue;
                }
                ReceiptHandleGroup group = (ReceiptHandleGroup)entry.getValue();
                group.scan((msgID, handleStr, v) -> {
                    long current = System.currentTimeMillis();
                    ReceiptHandle handle = ReceiptHandle.decode((String)v.getReceiptHandleStr());
                    if (handle.getNextVisibleTime() - current > proxyConfig.getRenewAheadTimeMillis()) {
                        return;
                    }
                    this.renewalWorkerService.submit(() -> this.renewMessage(this.createContext("RenewMessage"), key, group, msgID, handleStr));
                });
            }
        }
        catch (Exception e) {
            log.error("unexpect error when schedule renew task", (Throwable)e);
        }
        log.debug("scan for renewal done. cost:{}ms", (Object)stopwatch.elapsed().toMillis());
    }

    protected void renewMessage(ProxyContext context, ReceiptHandleGroupKey key, ReceiptHandleGroup group, String msgID, String handleStr) {
        try {
            group.computeIfPresent(msgID, handleStr, messageReceiptHandle -> this.startRenewMessage(context, key, (MessageReceiptHandle)messageReceiptHandle), 0L);
        }
        catch (Exception e) {
            log.error("error when renew message. msgID:{}, handleStr:{}", new Object[]{msgID, handleStr, e});
        }
    }

    protected CompletableFuture<MessageReceiptHandle> startRenewMessage(ProxyContext context, ReceiptHandleGroupKey key, MessageReceiptHandle messageReceiptHandle) {
        CompletableFuture<MessageReceiptHandle> resFuture = new CompletableFuture<MessageReceiptHandle>();
        ProxyConfig proxyConfig = ConfigurationManager.getProxyConfig();
        long current = System.currentTimeMillis();
        try {
            if (messageReceiptHandle.getRenewRetryTimes() >= proxyConfig.getMaxRenewRetryTimes()) {
                log.warn("handle has exceed max renewRetryTimes. handle:{}", (Object)messageReceiptHandle);
                return CompletableFuture.completedFuture(null);
            }
            if (current - messageReceiptHandle.getConsumeTimestamp() < proxyConfig.getRenewMaxTimeMillis()) {
                CompletableFuture<AckResult> future = new CompletableFuture<AckResult>();
                this.eventListener.fireEvent((Object)new RenewEvent(key, messageReceiptHandle, RENEW_POLICY.nextDelayDuration(messageReceiptHandle.getRenewTimes()), RenewEvent.EventType.RENEW, future));
                future.whenComplete((ackResult, throwable) -> {
                    if (throwable != null) {
                        log.error("error when renew. handle:{}", (Object)messageReceiptHandle, throwable);
                        if (this.renewExceptionNeedRetry((Throwable)throwable)) {
                            messageReceiptHandle.incrementAndGetRenewRetryTimes();
                            resFuture.complete(messageReceiptHandle);
                        } else {
                            resFuture.complete(null);
                        }
                    } else if (AckStatus.OK.equals((Object)ackResult.getStatus())) {
                        messageReceiptHandle.updateReceiptHandle(ackResult.getExtraInfo());
                        messageReceiptHandle.resetRenewRetryTimes();
                        messageReceiptHandle.incrementRenewTimes();
                        resFuture.complete(messageReceiptHandle);
                    } else {
                        log.error("renew response is not ok. result:{}, handle:{}", ackResult, (Object)messageReceiptHandle);
                        resFuture.complete(null);
                    }
                });
            } else {
                SubscriptionGroupConfig subscriptionGroupConfig = this.metadataService.getSubscriptionGroupConfig(context, messageReceiptHandle.getGroup());
                if (subscriptionGroupConfig == null) {
                    log.error("group's subscriptionGroupConfig is null when renew. handle: {}", (Object)messageReceiptHandle);
                    return CompletableFuture.completedFuture(null);
                }
                RetryPolicy retryPolicy = subscriptionGroupConfig.getGroupRetryPolicy().getRetryPolicy();
                CompletableFuture<AckResult> future = new CompletableFuture<AckResult>();
                this.eventListener.fireEvent((Object)new RenewEvent(key, messageReceiptHandle, retryPolicy.nextDelayDuration(messageReceiptHandle.getReconsumeTimes()), RenewEvent.EventType.STOP_RENEW, future));
                future.whenComplete((ackResult, throwable) -> {
                    if (throwable != null) {
                        log.error("error when nack in renew. handle:{}", (Object)messageReceiptHandle, throwable);
                    }
                    resFuture.complete(null);
                });
            }
        }
        catch (Throwable t) {
            log.error("unexpect error when renew message, stop to renew it. handle:{}", (Object)messageReceiptHandle, (Object)t);
            resFuture.complete(null);
        }
        return resFuture;
    }

    protected void clearGroup(ReceiptHandleGroupKey key) {
        if (key == null) {
            return;
        }
        ReceiptHandleGroup handleGroup = (ReceiptHandleGroup)this.receiptHandleGroupMap.remove(key);
        this.returnHandleGroupWorkerService.submit(() -> this.returnHandleGroup(key, handleGroup));
    }

    private void returnHandleGroup(ReceiptHandleGroupKey key, ReceiptHandleGroup handleGroup) {
        if (handleGroup == null || handleGroup.isEmpty()) {
            return;
        }
        ProxyConfig proxyConfig = ConfigurationManager.getProxyConfig();
        handleGroup.scan((msgID, handle, v) -> {
            try {
                handleGroup.computeIfPresent(msgID, handle, messageReceiptHandle -> {
                    CompletableFuture<AckResult> future = new CompletableFuture<AckResult>();
                    this.eventListener.fireEvent((Object)new RenewEvent(key, (MessageReceiptHandle)messageReceiptHandle, proxyConfig.getInvisibleTimeMillisWhenClear(), RenewEvent.EventType.CLEAR_GROUP, future));
                    return CompletableFuture.completedFuture(null);
                }, 0L);
            }
            catch (Exception e) {
                log.error("error when clear handle for group. key:{}", (Object)key, (Object)e);
            }
        });
        if (!handleGroup.isEmpty()) {
            log.warn("The handle cannot be completely cleared, the remaining quantity is {}, key:{}", (Object)handleGroup.getHandleNum(), (Object)key);
            this.receiptHandleGroupMap.putIfAbsent(key, handleGroup);
        }
    }

    protected void clearAllHandle() {
        log.info("start clear all handle in receiptHandleProcessor");
        Set keySet = this.receiptHandleGroupMap.keySet();
        for (ReceiptHandleGroupKey key : keySet) {
            this.clearGroup(key);
        }
        log.info("clear all handle in receiptHandleProcessor done");
    }

    protected boolean renewExceptionNeedRetry(Throwable t) {
        ProxyException proxyException;
        return !((t = ExceptionUtils.getRealException((Throwable)t)) instanceof ProxyException) || !ProxyExceptionCode.INVALID_BROKER_NAME.equals((Object)(proxyException = (ProxyException)t).getCode()) && !ProxyExceptionCode.INVALID_RECEIPT_HANDLE.equals((Object)proxyException.getCode());
    }

    protected ProxyContext createContext(String actionName) {
        return ProxyContext.createForInner(this.getClass().getSimpleName() + actionName);
    }
}

