/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.impl.consumer;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.rocketmq.client.impl.consumer.DefaultMQPushConsumerImpl;
import org.apache.rocketmq.client.impl.consumer.MQConsumerInner;
import org.apache.rocketmq.client.impl.consumer.MessageRequest;
import org.apache.rocketmq.client.impl.consumer.PopRequest;
import org.apache.rocketmq.client.impl.consumer.PullRequest;
import org.apache.rocketmq.client.impl.factory.MQClientInstance;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.ThreadFactoryImpl;
import org.apache.rocketmq.common.message.MessageRequestMode;
import org.apache.rocketmq.common.utils.ThreadUtils;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class PullMessageService
extends ServiceThread {
    private final Logger logger = LoggerFactory.getLogger(PullMessageService.class);
    private final LinkedBlockingQueue<MessageRequest> messageRequestQueue = new LinkedBlockingQueue();
    private final MQClientInstance mQClientFactory;
    private final ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ThreadFactoryImpl("PullMessageServiceScheduledThread"));

    public PullMessageService(MQClientInstance mQClientFactory) {
        this.mQClientFactory = mQClientFactory;
    }

    public void executePullRequestLater(final PullRequest pullRequest, long timeDelay) {
        if (!this.isStopped()) {
            this.scheduledExecutorService.schedule(new Runnable(){

                @Override
                public void run() {
                    PullMessageService.this.executePullRequestImmediately(pullRequest);
                }
            }, timeDelay, TimeUnit.MILLISECONDS);
        } else {
            this.logger.warn("PullMessageServiceScheduledThread has shutdown");
        }
    }

    public void executePullRequestImmediately(PullRequest pullRequest) {
        try {
            this.messageRequestQueue.put(pullRequest);
        }
        catch (InterruptedException e) {
            this.logger.error("executePullRequestImmediately pullRequestQueue.put", (Throwable)e);
        }
    }

    public void executePopPullRequestLater(final PopRequest popRequest, long timeDelay) {
        if (!this.isStopped()) {
            this.scheduledExecutorService.schedule(new Runnable(){

                @Override
                public void run() {
                    PullMessageService.this.executePopPullRequestImmediately(popRequest);
                }
            }, timeDelay, TimeUnit.MILLISECONDS);
        } else {
            this.logger.warn("PullMessageServiceScheduledThread has shutdown");
        }
    }

    public void executePopPullRequestImmediately(PopRequest popRequest) {
        try {
            this.messageRequestQueue.put(popRequest);
        }
        catch (InterruptedException e) {
            this.logger.error("executePullRequestImmediately pullRequestQueue.put", (Throwable)e);
        }
    }

    public void executeTaskLater(Runnable r, long timeDelay) {
        if (!this.isStopped()) {
            this.scheduledExecutorService.schedule(r, timeDelay, TimeUnit.MILLISECONDS);
        } else {
            this.logger.warn("PullMessageServiceScheduledThread has shutdown");
        }
    }

    public void executeTask(Runnable r) {
        if (!this.isStopped()) {
            this.scheduledExecutorService.execute(r);
        } else {
            this.logger.warn("PullMessageServiceScheduledThread has shutdown");
        }
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    private void pullMessage(PullRequest pullRequest) {
        MQConsumerInner consumer = this.mQClientFactory.selectConsumer(pullRequest.getConsumerGroup());
        if (consumer != null) {
            DefaultMQPushConsumerImpl impl = (DefaultMQPushConsumerImpl)consumer;
            impl.pullMessage(pullRequest);
        } else {
            this.logger.warn("No matched consumer for the PullRequest {}, drop it", (Object)pullRequest);
        }
    }

    private void popMessage(PopRequest popRequest) {
        MQConsumerInner consumer = this.mQClientFactory.selectConsumer(popRequest.getConsumerGroup());
        if (consumer != null) {
            DefaultMQPushConsumerImpl impl = (DefaultMQPushConsumerImpl)consumer;
            impl.popMessage(popRequest);
        } else {
            this.logger.warn("No matched consumer for the PopRequest {}, drop it", (Object)popRequest);
        }
    }

    public void run() {
        this.logger.info(this.getServiceName() + " service started");
        while (!this.isStopped()) {
            try {
                MessageRequest messageRequest = this.messageRequestQueue.take();
                if (messageRequest.getMessageRequestMode() == MessageRequestMode.POP) {
                    this.popMessage((PopRequest)messageRequest);
                    continue;
                }
                this.pullMessage((PullRequest)messageRequest);
            }
            catch (InterruptedException messageRequest) {
            }
            catch (Throwable e) {
                this.logger.error("Pull Message Service Run Method exception", e);
            }
        }
        this.logger.info(this.getServiceName() + " service end");
    }

    public void shutdown(boolean interrupt) {
        super.shutdown(interrupt);
        ThreadUtils.shutdownGracefully((ExecutorService)this.scheduledExecutorService, (long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public String getServiceName() {
        return PullMessageService.class.getSimpleName();
    }
}

