/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.cryptography.algorithms;

import com.microsoft.azure.keyvault.cryptography.AsymmetricSignatureAlgorithm;
import com.microsoft.azure.keyvault.cryptography.ISignatureTransform;
import com.microsoft.azure.keyvault.cryptography.SignatureEncoding;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.Provider;
import java.security.Signature;

public abstract class Ecdsa
extends AsymmetricSignatureAlgorithm {
    protected Ecdsa() {
        super("NONEwithEDCSA");
    }

    public ISignatureTransform createSignatureTransform(KeyPair key, Provider provider) {
        return new EcdsaSignatureTransform(key, provider, this);
    }

    public abstract int getDigestLength();

    public abstract int getCoordLength();

    private void checkDigestLength(byte[] digest) {
        if (digest.length != this.getDigestLength()) {
            throw new IllegalArgumentException("Invalid digest length.");
        }
    }

    class EcdsaSignatureTransform
    implements ISignatureTransform {
        private static final String ALGORITHM = "NONEwithECDSA";
        private final KeyPair keyPair;
        private final Provider provider;
        private final Ecdsa algorithm;

        EcdsaSignatureTransform(KeyPair keyPair, Provider provider, Ecdsa algorithm) {
            this.keyPair = keyPair;
            this.provider = provider;
            this.algorithm = algorithm;
        }

        @Override
        public byte[] sign(byte[] digest) throws GeneralSecurityException {
            Ecdsa.this.checkDigestLength(digest);
            Signature signature = Signature.getInstance(ALGORITHM, this.provider);
            signature.initSign(this.keyPair.getPrivate());
            signature.update(digest);
            return SignatureEncoding.fromAsn1Der(signature.sign(), this.algorithm);
        }

        @Override
        public boolean verify(byte[] digest, byte[] signature) throws GeneralSecurityException {
            Signature verify = Signature.getInstance(ALGORITHM, this.provider);
            Ecdsa.this.checkDigestLength(digest);
            signature = SignatureEncoding.toAsn1Der(signature, this.algorithm);
            verify.initVerify(this.keyPair.getPublic());
            verify.update(digest);
            return verify.verify(signature);
        }
    }
}

