/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.keyvault.cryptography;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.microsoft.azure.keyvault.core.IKey;
import com.microsoft.azure.keyvault.cryptography.Algorithm;
import com.microsoft.azure.keyvault.cryptography.AlgorithmResolver;
import com.microsoft.azure.keyvault.cryptography.AsymmetricEncryptionAlgorithm;
import com.microsoft.azure.keyvault.cryptography.AsymmetricSignatureAlgorithm;
import com.microsoft.azure.keyvault.cryptography.ICryptoTransform;
import com.microsoft.azure.keyvault.cryptography.ISignatureTransform;
import com.microsoft.azure.keyvault.cryptography.Strings;
import com.microsoft.azure.keyvault.cryptography.algorithms.Rs256;
import com.microsoft.azure.keyvault.webkey.JsonWebKey;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.interfaces.RSAPublicKey;
import java.util.UUID;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class RsaKey
implements IKey {
    public static final int KeySize1024 = 1024;
    public static final int KeySize2048 = 2048;
    public static final int KeySize4096 = 4096;
    private final String kid;
    private final KeyPair keyPair;
    private final Provider provider;

    public static int getDefaultKeySize() {
        return 2048;
    }

    public RsaKey() throws NoSuchAlgorithmException {
        this(UUID.randomUUID().toString());
    }

    public RsaKey(String kid) throws NoSuchAlgorithmException {
        this(kid, RsaKey.getDefaultKeySize());
    }

    public RsaKey(String kid, int keySize) throws NoSuchAlgorithmException {
        this(kid, keySize, null);
    }

    public RsaKey(String kid, int keySize, Provider provider) throws NoSuchAlgorithmException {
        if (Strings.isNullOrWhiteSpace(kid)) {
            throw new IllegalArgumentException("kid");
        }
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", provider);
        generator.initialize(keySize);
        this.kid = kid;
        this.keyPair = generator.generateKeyPair();
        this.provider = provider;
    }

    public RsaKey(String kid, KeyPair keyPair) {
        this(kid, keyPair, null);
    }

    public RsaKey(String kid, KeyPair keyPair, Provider provider) {
        if (Strings.isNullOrWhiteSpace(kid)) {
            throw new IllegalArgumentException("Please provide a kid");
        }
        if (keyPair == null) {
            throw new IllegalArgumentException("Please provide a KeyPair");
        }
        if (keyPair.getPublic() == null || !(keyPair.getPublic() instanceof RSAPublicKey)) {
            throw new IllegalArgumentException("The KeyPair is not an RsaKey");
        }
        this.kid = kid;
        this.keyPair = keyPair;
        this.provider = provider;
    }

    public static RsaKey fromJsonWebKey(JsonWebKey jwk) {
        return RsaKey.fromJsonWebKey(jwk, false, null);
    }

    public static RsaKey fromJsonWebKey(JsonWebKey jwk, boolean includePrivateParameters) {
        return RsaKey.fromJsonWebKey(jwk, includePrivateParameters, null);
    }

    public static RsaKey fromJsonWebKey(JsonWebKey jwk, boolean includePrivateParameters, Provider provider) {
        if (jwk.kid() != null) {
            return new RsaKey(jwk.kid(), jwk.toRSA(includePrivateParameters, provider));
        }
        throw new IllegalArgumentException("Json Web Key must have a kid");
    }

    public JsonWebKey toJsonWebKey() {
        return JsonWebKey.fromRSA((KeyPair)this.keyPair);
    }

    public String getDefaultEncryptionAlgorithm() {
        return "RSA-OAEP";
    }

    public String getDefaultKeyWrapAlgorithm() {
        return "RSA-OAEP";
    }

    public String getDefaultSignatureAlgorithm() {
        return "RS256";
    }

    public String getKid() {
        return this.kid;
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public ListenableFuture<byte[]> decryptAsync(byte[] ciphertext, byte[] iv, byte[] authenticationData, byte[] authenticationTag, String algorithm) throws NoSuchAlgorithmException {
        ListenableFuture result;
        if (ciphertext == null) {
            throw new IllegalArgumentException("ciphertext");
        }
        if (Strings.isNullOrWhiteSpace(algorithm)) {
            throw new IllegalArgumentException("algorithm");
        }
        Algorithm baseAlgorithm = AlgorithmResolver.Default.get(algorithm);
        if (baseAlgorithm == null || !(baseAlgorithm instanceof AsymmetricEncryptionAlgorithm)) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        AsymmetricEncryptionAlgorithm algo = (AsymmetricEncryptionAlgorithm)baseAlgorithm;
        try {
            ICryptoTransform transform = algo.CreateDecryptor(this.keyPair, this.provider);
            result = Futures.immediateFuture((Object)transform.doFinal(ciphertext));
        }
        catch (Exception e) {
            result = Futures.immediateFailedFuture((Throwable)e);
        }
        return result;
    }

    public ListenableFuture<Triple<byte[], byte[], String>> encryptAsync(byte[] plaintext, byte[] iv, byte[] authenticationData, String algorithm) throws NoSuchAlgorithmException {
        ListenableFuture result;
        if (plaintext == null) {
            throw new IllegalArgumentException("plaintext");
        }
        String algorithmName = Strings.isNullOrWhiteSpace(algorithm) ? this.getDefaultEncryptionAlgorithm() : algorithm;
        Algorithm baseAlgorithm = AlgorithmResolver.Default.get(algorithmName);
        if (baseAlgorithm == null || !(baseAlgorithm instanceof AsymmetricEncryptionAlgorithm)) {
            throw new NoSuchAlgorithmException(algorithmName);
        }
        AsymmetricEncryptionAlgorithm algo = (AsymmetricEncryptionAlgorithm)baseAlgorithm;
        try {
            ICryptoTransform transform = algo.CreateEncryptor(this.keyPair, this.provider);
            result = Futures.immediateFuture((Object)Triple.of((Object)transform.doFinal(plaintext), (Object)null, (Object)algorithmName));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            result = Futures.immediateFailedFuture((Throwable)e);
        }
        return result;
    }

    public ListenableFuture<Pair<byte[], String>> wrapKeyAsync(byte[] key, String algorithm) throws NoSuchAlgorithmException {
        ListenableFuture result;
        if (key == null) {
            throw new IllegalArgumentException("key");
        }
        String algorithmName = Strings.isNullOrWhiteSpace(algorithm) ? this.getDefaultKeyWrapAlgorithm() : algorithm;
        Algorithm baseAlgorithm = AlgorithmResolver.Default.get(algorithmName);
        if (baseAlgorithm == null || !(baseAlgorithm instanceof AsymmetricEncryptionAlgorithm)) {
            throw new NoSuchAlgorithmException(algorithmName);
        }
        AsymmetricEncryptionAlgorithm algo = (AsymmetricEncryptionAlgorithm)baseAlgorithm;
        try {
            ICryptoTransform transform = algo.CreateEncryptor(this.keyPair, this.provider);
            result = Futures.immediateFuture((Object)Pair.of((Object)transform.doFinal(key), (Object)algorithmName));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            result = Futures.immediateFailedFuture((Throwable)e);
        }
        return result;
    }

    public ListenableFuture<byte[]> unwrapKeyAsync(byte[] encryptedKey, String algorithm) throws NoSuchAlgorithmException {
        ListenableFuture result;
        if (encryptedKey == null) {
            throw new IllegalArgumentException("encryptedKey ");
        }
        if (Strings.isNullOrWhiteSpace(algorithm)) {
            throw new IllegalArgumentException("algorithm");
        }
        Algorithm baseAlgorithm = AlgorithmResolver.Default.get(algorithm);
        if (baseAlgorithm == null || !(baseAlgorithm instanceof AsymmetricEncryptionAlgorithm)) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        AsymmetricEncryptionAlgorithm algo = (AsymmetricEncryptionAlgorithm)baseAlgorithm;
        try {
            ICryptoTransform transform = algo.CreateDecryptor(this.keyPair, this.provider);
            result = Futures.immediateFuture((Object)transform.doFinal(encryptedKey));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            result = Futures.immediateFailedFuture((Throwable)e);
        }
        return result;
    }

    public ListenableFuture<Pair<byte[], String>> signAsync(byte[] digest, String algorithm) throws NoSuchAlgorithmException {
        if (digest == null) {
            throw new IllegalArgumentException("encryptedKey ");
        }
        if (Strings.isNullOrWhiteSpace(algorithm)) {
            throw new IllegalArgumentException("algorithm");
        }
        Algorithm baseAlgorithm = AlgorithmResolver.Default.get(algorithm);
        if (baseAlgorithm == null || !(baseAlgorithm instanceof AsymmetricSignatureAlgorithm)) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        Rs256 algo = (Rs256)baseAlgorithm;
        ISignatureTransform signer = algo.createSignatureTransform(this.keyPair);
        try {
            return Futures.immediateFuture((Object)Pair.of((Object)signer.sign(digest), (Object)"RS256"));
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    public ListenableFuture<Boolean> verifyAsync(byte[] digest, byte[] signature, String algorithm) throws NoSuchAlgorithmException {
        if (digest == null) {
            throw new IllegalArgumentException("encryptedKey ");
        }
        if (Strings.isNullOrWhiteSpace(algorithm)) {
            throw new IllegalArgumentException("algorithm");
        }
        Algorithm baseAlgorithm = AlgorithmResolver.Default.get(algorithm);
        if (baseAlgorithm == null || !(baseAlgorithm instanceof AsymmetricSignatureAlgorithm)) {
            throw new NoSuchAlgorithmException(algorithm);
        }
        Rs256 algo = (Rs256)baseAlgorithm;
        ISignatureTransform signer = algo.createSignatureTransform(this.keyPair);
        try {
            return Futures.immediateFuture((Object)signer.verify(digest, signature));
        }
        catch (Exception e) {
            return Futures.immediateFailedFuture((Throwable)e);
        }
    }

    public void close() throws IOException {
    }
}

