/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.trafficmanager.implementation;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.AzureResponseBuilder;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.resources.fluentcore.arm.AzureConfigurable;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.Manager;
import com.microsoft.azure.management.resources.fluentcore.utils.ProviderRegistrationInterceptor;
import com.microsoft.azure.management.resources.fluentcore.utils.ResourceManagerThrottlingInterceptor;
import com.microsoft.azure.management.trafficmanager.TrafficManagerProfiles;
import com.microsoft.azure.management.trafficmanager.implementation.TrafficManagerManagementClientImpl;
import com.microsoft.azure.management.trafficmanager.implementation.TrafficManagerProfilesImpl;
import com.microsoft.azure.serializer.AzureJacksonAdapter;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.protocol.Environment;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import okhttp3.Interceptor;

public final class TrafficManager
extends Manager<TrafficManager, TrafficManagerManagementClientImpl> {
    private TrafficManagerProfiles profiles;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static TrafficManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
        return new TrafficManager(new RestClient.Builder().withBaseUrl((Environment)credentials.environment(), (Environment.Endpoint)AzureEnvironment.Endpoint.RESOURCE_MANAGER).withCredentials((ServiceClientCredentials)credentials).withSerializerAdapter((SerializerAdapter)new AzureJacksonAdapter()).withResponseBuilderFactory((ResponseBuilder.Factory)new AzureResponseBuilder.Factory()).withInterceptor((Interceptor)new ProviderRegistrationInterceptor(credentials)).withInterceptor((Interceptor)new ResourceManagerThrottlingInterceptor()).build(), subscriptionId);
    }

    public static TrafficManager authenticate(RestClient restClient, String subscriptionId) {
        return new TrafficManager(restClient, subscriptionId);
    }

    private TrafficManager(RestClient restClient, String subscriptionId) {
        super(restClient, subscriptionId, (Object)new TrafficManagerManagementClientImpl(restClient).withSubscriptionId(subscriptionId));
    }

    public TrafficManagerProfiles profiles() {
        if (this.profiles == null) {
            this.profiles = new TrafficManagerProfilesImpl(this);
        }
        return this.profiles;
    }

    private static class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public TrafficManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
            return TrafficManager.authenticate(this.buildRestClient(credentials), subscriptionId);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public TrafficManager authenticate(AzureTokenCredentials var1, String var2);
    }
}

