/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.redis.implementation;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.AzureResponseBuilder;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.redis.RedisCaches;
import com.microsoft.azure.management.redis.implementation.RedisCachesImpl;
import com.microsoft.azure.management.redis.implementation.RedisManagementClientImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.AzureConfigurable;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.Manager;
import com.microsoft.azure.management.resources.fluentcore.utils.ProviderRegistrationInterceptor;
import com.microsoft.azure.management.resources.fluentcore.utils.ResourceManagerThrottlingInterceptor;
import com.microsoft.azure.serializer.AzureJacksonAdapter;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.protocol.Environment;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import okhttp3.Interceptor;

public final class RedisManager
extends Manager<RedisManager, RedisManagementClientImpl> {
    private RedisCaches redisCaches;

    private RedisManager(RestClient restClient, String subscriptionId) {
        super(restClient, subscriptionId, (Object)new RedisManagementClientImpl(restClient).withSubscriptionId(subscriptionId));
    }

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static RedisManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
        return new RedisManager(new RestClient.Builder().withBaseUrl((Environment)credentials.environment(), (Environment.Endpoint)AzureEnvironment.Endpoint.RESOURCE_MANAGER).withCredentials((ServiceClientCredentials)credentials).withSerializerAdapter((SerializerAdapter)new AzureJacksonAdapter()).withResponseBuilderFactory((ResponseBuilder.Factory)new AzureResponseBuilder.Factory()).withInterceptor((Interceptor)new ProviderRegistrationInterceptor(credentials)).withInterceptor((Interceptor)new ResourceManagerThrottlingInterceptor()).build(), subscriptionId);
    }

    public static RedisManager authenticate(RestClient restClient, String subscriptionId) {
        return new RedisManager(restClient, subscriptionId);
    }

    public RedisCaches redisCaches() {
        if (this.redisCaches == null) {
            this.redisCaches = new RedisCachesImpl(this);
        }
        return this.redisCaches;
    }

    private static final class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public RedisManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
            return RedisManager.authenticate(this.buildRestClient(credentials), subscriptionId);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public RedisManager authenticate(AzureTokenCredentials var1, String var2);
    }
}

