/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.nio.MappedByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hdfs.ExtendedBlockId;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.MappableBlock;
import org.apache.hadoop.io.nativeio.NativeIO;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class MemoryMappedBlock
implements MappableBlock {
    private MappedByteBuffer mmap;
    private final long length;

    MemoryMappedBlock(MappedByteBuffer mmap, long length) {
        this.mmap = mmap;
        this.length = length;
        assert (length > 0L);
    }

    @Override
    public long getLength() {
        return this.length;
    }

    @Override
    public long getAddress() {
        return -1L;
    }

    @Override
    public ExtendedBlockId getKey() {
        return null;
    }

    @Override
    public void close() {
        if (this.mmap != null) {
            NativeIO.POSIX.munmap((MappedByteBuffer)this.mmap);
            this.mmap = null;
        }
    }
}

