/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batchai.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.batchai.BatchAIJob;
import com.microsoft.azure.management.batchai.ContainerImageSettings;
import com.microsoft.azure.management.batchai.ContainerSettings;
import com.microsoft.azure.management.batchai.ImageSourceRegistry;
import com.microsoft.azure.management.batchai.KeyVaultSecretReference;
import com.microsoft.azure.management.batchai.PrivateRegistryCredentials;
import com.microsoft.azure.management.batchai.ResourceId;
import com.microsoft.azure.management.batchai.implementation.BatchAIJobImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableWrapperImpl;

@LangDefinition
class ContainerImageSettingsImpl
extends IndexableWrapperImpl<ContainerSettings>
implements ContainerImageSettings.Definition<BatchAIJob.DefinitionStages.WithCreate> {
    private BatchAIJobImpl parent;

    protected ContainerImageSettingsImpl(ContainerSettings inner, BatchAIJobImpl parent) {
        super((Object)inner);
        this.parent = parent;
    }

    public BatchAIJob.DefinitionStages.WithCreate attach() {
        this.parent.attachContainerSettings(this);
        return this.parent;
    }

    public ContainerImageSettingsImpl withRegistryUrl(String serverUrl) {
        this.ensureImageSourceRegistry().withServerUrl(serverUrl);
        return this;
    }

    public ContainerImageSettingsImpl withRegistryUsername(String username) {
        this.ensureImageSourceRegistry().withCredentials(new PrivateRegistryCredentials().withUsername(username));
        return this;
    }

    public ContainerImageSettingsImpl withRegistryPassword(String password) {
        this.ensureImageSourceRegistry().credentials().withPassword(password);
        return this;
    }

    public ContainerImageSettingsImpl withRegistrySecretReference(String keyVaultId, String secretUrl) {
        this.ensureImageSourceRegistry().credentials().withPasswordSecretReference(new KeyVaultSecretReference().withSourceVault(new ResourceId().withId(keyVaultId)).withSecretUrl(secretUrl));
        return this;
    }

    public ContainerImageSettingsImpl withShmSize(String shmSize) {
        ((ContainerSettings)this.inner()).withShmSize(shmSize);
        return this;
    }

    private ImageSourceRegistry ensureImageSourceRegistry() {
        if (((ContainerSettings)this.inner()).imageSourceRegistry() == null) {
            ((ContainerSettings)this.inner()).withImageSourceRegistry(new ImageSourceRegistry());
        }
        return ((ContainerSettings)this.inner()).imageSourceRegistry();
    }
}

