/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.eventhub.implementation;

import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.eventhub.EventHubConsumerGroup;
import com.microsoft.azure.management.eventhub.EventHubConsumerGroups;
import com.microsoft.azure.management.eventhub.implementation.ConsumerGroupInner;
import com.microsoft.azure.management.eventhub.implementation.ConsumerGroupsInner;
import com.microsoft.azure.management.eventhub.implementation.EventHubConsumerGroupImpl;
import com.microsoft.azure.management.eventhub.implementation.EventHubManagementClientImpl;
import com.microsoft.azure.management.eventhub.implementation.EventHubManager;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.WrapperImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import java.util.Objects;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class EventHubConsumerGroupsImpl
extends WrapperImpl<ConsumerGroupsInner>
implements EventHubConsumerGroups {
    private final EventHubManager manager;

    protected EventHubConsumerGroupsImpl(EventHubManager manager) {
        super((Object)((EventHubManagementClientImpl)((Object)manager.inner())).consumerGroups());
        this.manager = manager;
    }

    public EventHubManager manager() {
        return this.manager;
    }

    public EventHubConsumerGroupImpl define(String name) {
        return new EventHubConsumerGroupImpl(name, this.manager);
    }

    public EventHubConsumerGroup getById(String id) {
        return (EventHubConsumerGroup)this.getByIdAsync(id).toBlocking().last();
    }

    public Observable<EventHubConsumerGroup> getByIdAsync(String id) {
        Objects.requireNonNull(id);
        ResourceId resourceId = ResourceId.fromString((String)id);
        return this.getByNameAsync(resourceId.resourceGroupName(), resourceId.parent().parent().name(), resourceId.parent().name(), resourceId.name());
    }

    public ServiceFuture<EventHubConsumerGroup> getByIdAsync(String id, ServiceCallback<EventHubConsumerGroup> callback) {
        return ServiceFuture.fromBody(this.getByIdAsync(id), callback);
    }

    @Override
    public Observable<EventHubConsumerGroup> getByNameAsync(String resourceGroupName, String namespaceName, String eventHubName, String name) {
        return ((ConsumerGroupsInner)this.inner()).getAsync(resourceGroupName, namespaceName, eventHubName, name).map((Func1)new Func1<ConsumerGroupInner, EventHubConsumerGroup>(){

            public EventHubConsumerGroup call(ConsumerGroupInner inner) {
                if (inner == null) {
                    return null;
                }
                return EventHubConsumerGroupsImpl.this.wrapModel(inner);
            }
        });
    }

    @Override
    public EventHubConsumerGroup getByName(String resourceGroupName, String namespaceName, String eventHubName, String name) {
        return (EventHubConsumerGroup)this.getByNameAsync(resourceGroupName, namespaceName, eventHubName, name).toBlocking().last();
    }

    @Override
    public PagedList<EventHubConsumerGroup> listByEventHub(String resourceGroupName, String namespaceName, String eventHubName) {
        return new PagedListConverter<ConsumerGroupInner, EventHubConsumerGroup>(){

            public Observable<EventHubConsumerGroup> typeConvertAsync(ConsumerGroupInner inner) {
                return Observable.just((Object)EventHubConsumerGroupsImpl.this.wrapModel(inner));
            }
        }.convert(((ConsumerGroupsInner)this.inner()).listByEventHub(resourceGroupName, namespaceName, eventHubName));
    }

    @Override
    public Observable<EventHubConsumerGroup> listByEventHubAsync(String resourceGroupName, String namespaceName, String eventHubName) {
        return ((ConsumerGroupsInner)this.inner()).listByEventHubAsync(resourceGroupName, namespaceName, eventHubName).flatMapIterable((Func1)new Func1<Page<ConsumerGroupInner>, Iterable<ConsumerGroupInner>>(){

            public Iterable<ConsumerGroupInner> call(Page<ConsumerGroupInner> page) {
                return page.items();
            }
        }).map((Func1)new Func1<ConsumerGroupInner, EventHubConsumerGroup>(){

            public EventHubConsumerGroup call(ConsumerGroupInner inner) {
                return EventHubConsumerGroupsImpl.this.wrapModel(inner);
            }
        });
    }

    public void deleteById(String id) {
        this.deleteByIdAsync(id).await();
    }

    public ServiceFuture<Void> deleteByIdAsync(String id, ServiceCallback<Void> callback) {
        return ServiceFuture.fromBody((Completable)this.deleteByIdAsync(id), callback);
    }

    public Completable deleteByIdAsync(String id) {
        Objects.requireNonNull(id);
        ResourceId resourceId = ResourceId.fromString((String)id);
        return this.deleteByNameAsync(resourceId.resourceGroupName(), resourceId.parent().parent().name(), resourceId.parent().name(), resourceId.name());
    }

    @Override
    public Completable deleteByNameAsync(String resourceGroupName, String namespaceName, String eventHubName, String name) {
        return ((ConsumerGroupsInner)this.inner()).deleteAsync(resourceGroupName, namespaceName, eventHubName, name).toCompletable();
    }

    @Override
    public void deleteByName(String resourceGroupName, String namespaceName, String eventHubName, String name) {
        this.deleteByNameAsync(resourceGroupName, namespaceName, eventHubName, name).await();
    }

    private EventHubConsumerGroupImpl wrapModel(ConsumerGroupInner innerModel) {
        return new EventHubConsumerGroupImpl(innerModel.name(), innerModel, this.manager);
    }
}

