/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.network.implementation;

import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.network.ExpressRouteCircuit;
import com.microsoft.azure.management.network.ExpressRouteCircuitPeering;
import com.microsoft.azure.management.network.ExpressRouteCircuitPeerings;
import com.microsoft.azure.management.network.ExpressRoutePeeringType;
import com.microsoft.azure.management.network.implementation.ExpressRouteCircuitImpl;
import com.microsoft.azure.management.network.implementation.ExpressRouteCircuitPeeringImpl;
import com.microsoft.azure.management.network.implementation.ExpressRouteCircuitPeeringInner;
import com.microsoft.azure.management.network.implementation.ExpressRouteCircuitPeeringsInner;
import com.microsoft.azure.management.network.implementation.NetworkManagementClientImpl;
import com.microsoft.azure.management.network.implementation.NetworkManager;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.IndependentChildrenImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.collection.implementation.ReadableWrappersImpl;
import com.microsoft.azure.management.resources.fluentcore.utils.PagedListConverter;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
class ExpressRouteCircuitPeeringsImpl
extends IndependentChildrenImpl<ExpressRouteCircuitPeering, ExpressRouteCircuitPeeringImpl, ExpressRouteCircuitPeeringInner, ExpressRouteCircuitPeeringsInner, NetworkManager, ExpressRouteCircuit>
implements ExpressRouteCircuitPeerings {
    private final ExpressRouteCircuitImpl parent;

    ExpressRouteCircuitPeeringsImpl(ExpressRouteCircuitImpl parent) {
        super((Object)((NetworkManagementClientImpl)((Object)((NetworkManager)parent.manager()).inner())).expressRouteCircuitPeerings(), parent.manager());
        this.parent = parent;
    }

    public final PagedList<ExpressRouteCircuitPeering> list() {
        return new PagedListConverter<ExpressRouteCircuitPeeringInner, ExpressRouteCircuitPeering>(){

            public Observable<ExpressRouteCircuitPeering> typeConvertAsync(ExpressRouteCircuitPeeringInner inner) {
                return Observable.just((Object)ExpressRouteCircuitPeeringsImpl.this.wrapModel(inner));
            }
        }.convert(ReadableWrappersImpl.convertToPagedList(((ExpressRouteCircuitPeeringsInner)this.inner()).list(this.parent.resourceGroupName(), this.parent.name())));
    }

    public Observable<ExpressRouteCircuitPeering> listAsync() {
        return this.wrapPageAsync(((ExpressRouteCircuitPeeringsInner)this.inner()).listAsync(this.parent.resourceGroupName(), this.parent.name()));
    }

    protected ExpressRouteCircuitPeeringImpl wrapModel(String name) {
        return new ExpressRouteCircuitPeeringImpl(this.parent, new ExpressRouteCircuitPeeringInner(), (ExpressRouteCircuitPeeringsInner)this.inner(), ExpressRoutePeeringType.fromString(name));
    }

    protected ExpressRouteCircuitPeeringImpl wrapModel(ExpressRouteCircuitPeeringInner inner) {
        return inner == null ? null : new ExpressRouteCircuitPeeringImpl(this.parent, inner, (ExpressRouteCircuitPeeringsInner)this.inner(), inner.peeringType());
    }

    @Override
    public ExpressRouteCircuitPeeringImpl defineAzurePrivatePeering() {
        return new ExpressRouteCircuitPeeringImpl(this.parent, new ExpressRouteCircuitPeeringInner(), (ExpressRouteCircuitPeeringsInner)this.inner(), ExpressRoutePeeringType.AZURE_PRIVATE_PEERING);
    }

    @Override
    public ExpressRouteCircuitPeeringImpl defineAzurePublicPeering() {
        return new ExpressRouteCircuitPeeringImpl(this.parent, new ExpressRouteCircuitPeeringInner(), (ExpressRouteCircuitPeeringsInner)this.inner(), ExpressRoutePeeringType.AZURE_PUBLIC_PEERING);
    }

    @Override
    public ExpressRouteCircuitPeeringImpl defineMicrosoftPeering() {
        return new ExpressRouteCircuitPeeringImpl(this.parent, new ExpressRouteCircuitPeeringInner(), (ExpressRouteCircuitPeeringsInner)this.inner(), ExpressRoutePeeringType.MICROSOFT_PEERING);
    }

    public Observable<ExpressRouteCircuitPeering> getByNameAsync(String name) {
        return ((ExpressRouteCircuitPeeringsInner)this.inner()).getAsync(this.parent.resourceGroupName(), this.parent.name(), name).map((Func1)new Func1<ExpressRouteCircuitPeeringInner, ExpressRouteCircuitPeering>(){

            public ExpressRouteCircuitPeering call(ExpressRouteCircuitPeeringInner inner) {
                return ExpressRouteCircuitPeeringsImpl.this.wrapModel(inner);
            }
        });
    }

    public ExpressRouteCircuitPeering getByName(String name) {
        return (ExpressRouteCircuitPeering)this.getByNameAsync(name).toBlocking().last();
    }

    public void deleteByName(String name) {
        this.deleteByNameAsync(name).await();
    }

    public ServiceFuture<Void> deleteByNameAsync(String name, ServiceCallback<Void> callback) {
        return ((ExpressRouteCircuitPeeringsInner)this.inner()).deleteAsync(this.parent.resourceGroupName(), this.parent.name(), name, callback);
    }

    public Completable deleteByNameAsync(String name) {
        return ((ExpressRouteCircuitPeeringsInner)this.inner()).deleteAsync(this.parent.resourceGroupName(), this.parent.name(), name).toCompletable();
    }

    public ExpressRouteCircuit parent() {
        return this.parent;
    }

    public Completable deleteByParentAsync(String groupName, String parentName, String name) {
        return ((ExpressRouteCircuitPeeringsInner)this.inner()).deleteAsync(groupName, parentName, name).toCompletable();
    }

    public Observable<ExpressRouteCircuitPeering> getByParentAsync(String resourceGroup, String parentName, String name) {
        return ((ExpressRouteCircuitPeeringsInner)this.inner()).getAsync(resourceGroup, parentName, name).map((Func1)new Func1<ExpressRouteCircuitPeeringInner, ExpressRouteCircuitPeering>(){

            public ExpressRouteCircuitPeering call(ExpressRouteCircuitPeeringInner inner) {
                return ExpressRouteCircuitPeeringsImpl.this.wrapModel(inner);
            }
        });
    }

    public PagedList<ExpressRouteCircuitPeering> listByParent(String resourceGroupName, String parentName) {
        return this.wrapList(((ExpressRouteCircuitPeeringsInner)this.inner()).list(resourceGroupName, parentName));
    }
}

