/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.servicebus.implementation;

import com.microsoft.azure.AzureEnvironment;
import com.microsoft.azure.AzureResponseBuilder;
import com.microsoft.azure.credentials.AzureTokenCredentials;
import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.resources.fluentcore.arm.AzureConfigurable;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.AzureConfigurableImpl;
import com.microsoft.azure.management.resources.fluentcore.arm.implementation.Manager;
import com.microsoft.azure.management.resources.fluentcore.utils.ProviderRegistrationInterceptor;
import com.microsoft.azure.management.resources.fluentcore.utils.ResourceManagerThrottlingInterceptor;
import com.microsoft.azure.management.servicebus.ServiceBusNamespaces;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusManagementClientImpl;
import com.microsoft.azure.management.servicebus.implementation.ServiceBusNamespacesImpl;
import com.microsoft.azure.serializer.AzureJacksonAdapter;
import com.microsoft.rest.RestClient;
import com.microsoft.rest.credentials.ServiceClientCredentials;
import com.microsoft.rest.protocol.Environment;
import com.microsoft.rest.protocol.ResponseBuilder;
import com.microsoft.rest.protocol.SerializerAdapter;
import okhttp3.Interceptor;

@Beta
public final class ServiceBusManager
extends Manager<ServiceBusManager, ServiceBusManagementClientImpl> {
    private ServiceBusNamespacesImpl namespaces;

    public static Configurable configure() {
        return new ConfigurableImpl();
    }

    public static ServiceBusManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
        return new ServiceBusManager(new RestClient.Builder().withBaseUrl((Environment)credentials.environment(), (Environment.Endpoint)AzureEnvironment.Endpoint.RESOURCE_MANAGER).withCredentials((ServiceClientCredentials)credentials).withSerializerAdapter((SerializerAdapter)new AzureJacksonAdapter()).withResponseBuilderFactory((ResponseBuilder.Factory)new AzureResponseBuilder.Factory()).withInterceptor((Interceptor)new ProviderRegistrationInterceptor(credentials)).withInterceptor((Interceptor)new ResourceManagerThrottlingInterceptor()).build(), subscriptionId);
    }

    public static ServiceBusManager authenticate(RestClient restClient, String subscriptionId) {
        return new ServiceBusManager(restClient, subscriptionId);
    }

    private ServiceBusManager(RestClient restClient, String subscriptionId) {
        super(restClient, subscriptionId, (Object)new ServiceBusManagementClientImpl(restClient).withSubscriptionId(subscriptionId));
    }

    public ServiceBusNamespaces namespaces() {
        if (this.namespaces == null) {
            this.namespaces = new ServiceBusNamespacesImpl(((ServiceBusManagementClientImpl)((Object)this.inner())).namespaces(), this);
        }
        return this.namespaces;
    }

    private static class ConfigurableImpl
    extends AzureConfigurableImpl<Configurable>
    implements Configurable {
        private ConfigurableImpl() {
        }

        @Override
        public ServiceBusManager authenticate(AzureTokenCredentials credentials, String subscriptionId) {
            return ServiceBusManager.authenticate(this.buildRestClient(credentials), subscriptionId);
        }
    }

    public static interface Configurable
    extends AzureConfigurable<Configurable> {
        public ServiceBusManager authenticate(AzureTokenCredentials var1, String var2);
    }
}

