/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.containerservice;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.containerservice.ContainerServiceNetworkProfile;
import com.microsoft.azure.management.containerservice.KubernetesClusterAgentPool;
import com.microsoft.azure.management.containerservice.KubernetesVersion;
import com.microsoft.azure.management.containerservice.ManagedClusterAddonProfile;
import com.microsoft.azure.management.containerservice.NetworkPlugin;
import com.microsoft.azure.management.containerservice.NetworkPolicy;
import com.microsoft.azure.management.containerservice.OrchestratorServiceBase;
import com.microsoft.azure.management.containerservice.implementation.ContainerServiceManager;
import com.microsoft.azure.management.containerservice.implementation.ManagedClusterInner;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Attachable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import java.util.Map;

@Fluent
@Beta(value=Beta.SinceVersion.V1_15_0)
public interface KubernetesCluster
extends GroupableResource<ContainerServiceManager, ManagedClusterInner>,
Refreshable<KubernetesCluster>,
Updatable<Update>,
OrchestratorServiceBase {
    public String provisioningState();

    public String dnsPrefix();

    public String fqdn();

    public KubernetesVersion version();

    public byte[] adminKubeConfigContent();

    public byte[] userKubeConfigContent();

    public String servicePrincipalClientId();

    public String servicePrincipalSecret();

    public String linuxRootUsername();

    public String sshKey();

    public Map<String, KubernetesClusterAgentPool> agentPools();

    @Beta(value=Beta.SinceVersion.V1_15_0)
    public ContainerServiceNetworkProfile networkProfile();

    @Beta(value=Beta.SinceVersion.V1_15_0)
    public Map<String, ManagedClusterAddonProfile> addonProfiles();

    @Beta(value=Beta.SinceVersion.V1_15_0)
    public String nodeResourceGroup();

    @Beta(value=Beta.SinceVersion.V1_15_0)
    public boolean enableRBAC();

    public static interface UpdateStages {

        public static interface WithRBAC {
            @Beta(value=Beta.SinceVersion.V1_15_0)
            public Update withRBACEnabled();

            @Beta(value=Beta.SinceVersion.V1_15_0)
            public Update withRBACDisabled();
        }

        public static interface WithNetworkProfile {
            @Beta(value=Beta.SinceVersion.V1_15_0)
            public Update withNetworkProfile(ContainerServiceNetworkProfile var1);
        }

        public static interface WithAddOnProfiles {
            @Beta(value=Beta.SinceVersion.V1_15_0)
            public Update withAddOnProfiles(Map<String, ManagedClusterAddonProfile> var1);
        }

        public static interface WithUpdateAgentPoolCount {
            @Beta(value=Beta.SinceVersion.V1_15_0)
            public Update withAgentPoolVirtualMachineCount(String var1, int var2);

            @Beta(value=Beta.SinceVersion.V1_15_0)
            public Update withAgentPoolVirtualMachineCount(int var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithUpdateAgentPoolCount,
    UpdateStages.WithAddOnProfiles,
    UpdateStages.WithNetworkProfile,
    UpdateStages.WithRBAC,
    Resource.UpdateWithTags<Update>,
    Appliable<KubernetesCluster> {
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<KubernetesCluster>,
        WithNetworkProfile,
        WithDnsPrefix,
        WithAddOnProfiles,
        Resource.DefinitionWithTags<WithCreate> {
        }

        public static interface WithAddOnProfiles {
            @Beta(value=Beta.SinceVersion.V1_15_0)
            public Update withAddOnProfiles(Map<String, ManagedClusterAddonProfile> var1);
        }

        public static interface WithDnsPrefix {
            public WithCreate withDnsPrefix(String var1);
        }

        public static interface NetworkProfileDefinition<ParentT>
        extends NetworkProfileDefinitionStages.Blank<ParentT>,
        NetworkProfileDefinitionStages.WithNetworkPolicy<ParentT>,
        NetworkProfileDefinitionStages.WithPodCidr<ParentT>,
        NetworkProfileDefinitionStages.WithServiceCidr<ParentT>,
        NetworkProfileDefinitionStages.WithDnsServiceIP<ParentT>,
        NetworkProfileDefinitionStages.WithDockerBridgeCidr<ParentT>,
        NetworkProfileDefinitionStages.WithAttach<ParentT> {
        }

        public static interface NetworkProfileDefinitionStages {

            public static interface WithAttach<ParentT>
            extends WithNetworkPolicy<ParentT>,
            WithPodCidr<ParentT>,
            WithServiceCidr<ParentT>,
            WithDnsServiceIP<ParentT>,
            WithDockerBridgeCidr<ParentT>,
            Attachable.InDefinition<ParentT> {
            }

            public static interface WithDockerBridgeCidr<ParentT> {
                public WithAttach<ParentT> withDockerBridgeCidr(String var1);
            }

            public static interface WithDnsServiceIP<ParentT> {
                public WithAttach<ParentT> withDnsServiceIP(String var1);
            }

            public static interface WithServiceCidr<ParentT> {
                public WithAttach<ParentT> withServiceCidr(String var1);
            }

            public static interface WithPodCidr<ParentT> {
                public WithAttach<ParentT> withPodCidr(String var1);
            }

            public static interface WithNetworkPolicy<ParentT> {
                public WithAttach<ParentT> withNetworkPolicy(NetworkPolicy var1);
            }

            @Beta(value=Beta.SinceVersion.V1_15_0)
            public static interface Blank<ParentT>
            extends WithAttach<ParentT> {
                public WithAttach<ParentT> withNetworkPlugin(NetworkPlugin var1);
            }
        }

        @Beta(value=Beta.SinceVersion.V1_15_0)
        public static interface WithNetworkProfile {
            @Beta(value=Beta.SinceVersion.V1_15_0)
            public NetworkProfileDefinitionStages.Blank<WithCreate> defineNetworkProfile();
        }

        public static interface WithAgentPool {
            public KubernetesClusterAgentPool.DefinitionStages.Blank<WithCreate> defineAgentPool(String var1);
        }

        public static interface WithServicePrincipalProfile {
            public WithAgentPool withServicePrincipalSecret(String var1);
        }

        public static interface WithServicePrincipalClientId {
            public WithServicePrincipalProfile withServicePrincipalClientId(String var1);
        }

        public static interface WithLinuxSshKey {
            public WithServicePrincipalClientId withSshKey(String var1);
        }

        public static interface WithLinuxRootUsername {
            public WithLinuxSshKey withRootUsername(String var1);
        }

        public static interface WithVersion {
            @Deprecated
            public WithLinuxRootUsername withVersion(KubernetesVersion var1);

            public WithLinuxRootUsername withVersion(String var1);

            @Method
            public WithLinuxRootUsername withLatestVersion();
        }

        public static interface WithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithVersion> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<WithGroup> {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithGroup,
    DefinitionStages.WithVersion,
    DefinitionStages.WithLinuxRootUsername,
    DefinitionStages.WithLinuxSshKey,
    DefinitionStages.WithServicePrincipalClientId,
    DefinitionStages.WithServicePrincipalProfile,
    DefinitionStages.WithDnsPrefix,
    DefinitionStages.WithAgentPool,
    DefinitionStages.WithNetworkProfile,
    DefinitionStages.WithAddOnProfiles,
    DefinitionStages.WithCreate {
    }
}

