/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.bootstrap;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.Constants;
import org.elasticsearch.bootstrap.ConsoleCtrlHandler;
import org.elasticsearch.bootstrap.JNACLibrary;
import org.elasticsearch.bootstrap.JNAKernel32Library;
import org.elasticsearch.bootstrap.SystemCallFilter;
import org.elasticsearch.monitor.jvm.JvmInfo;

class JNANatives {
    private static final Logger logger = LogManager.getLogger(JNANatives.class);
    static boolean LOCAL_MLOCKALL = false;
    static boolean LOCAL_SYSTEM_CALL_FILTER = false;
    static boolean LOCAL_SYSTEM_CALL_FILTER_ALL = false;
    static long MAX_NUMBER_OF_THREADS = -1L;
    static long MAX_SIZE_VIRTUAL_MEMORY = Long.MIN_VALUE;
    static long MAX_FILE_SIZE = Long.MIN_VALUE;

    private JNANatives() {
    }

    static void tryMlockall() {
        int errno = Integer.MIN_VALUE;
        String errMsg = null;
        boolean rlimitSuccess = false;
        long softLimit = 0L;
        long hardLimit = 0L;
        try {
            int result = JNACLibrary.mlockall(1);
            if (result == 0) {
                LOCAL_MLOCKALL = true;
                return;
            }
            errno = Native.getLastError();
            errMsg = JNACLibrary.strerror(errno);
            if (Constants.LINUX || Constants.MAC_OS_X) {
                JNACLibrary.Rlimit rlimit = new JNACLibrary.Rlimit();
                if (JNACLibrary.getrlimit(JNACLibrary.RLIMIT_MEMLOCK, rlimit) == 0) {
                    rlimitSuccess = true;
                    softLimit = rlimit.rlim_cur.longValue();
                    hardLimit = rlimit.rlim_max.longValue();
                } else {
                    logger.warn("Unable to retrieve resource limits: {}", (Object)JNACLibrary.strerror(Native.getLastError()));
                }
            }
        }
        catch (UnsatisfiedLinkError e) {
            return;
        }
        logger.warn("Unable to lock JVM Memory: error={}, reason={}", (Object)errno, (Object)errMsg);
        logger.warn("This can result in part of the JVM being swapped out.");
        if (errno == 12) {
            if (rlimitSuccess) {
                logger.warn("Increase RLIMIT_MEMLOCK, soft limit: {}, hard limit: {}", (Object)JNANatives.rlimitToString(softLimit), (Object)JNANatives.rlimitToString(hardLimit));
                if (Constants.LINUX) {
                    String user = System.getProperty("user.name");
                    logger.warn("These can be adjusted by modifying /etc/security/limits.conf, for example: \n\t# allow user '{}' mlockall\n\t{} soft memlock unlimited\n\t{} hard memlock unlimited", (Object)user, (Object)user, (Object)user);
                    logger.warn("If you are logged in interactively, you will have to re-login for the new limits to take effect.");
                }
            } else {
                logger.warn("Increase RLIMIT_MEMLOCK (ulimit).");
            }
        }
    }

    static void trySetMaxNumberOfThreads() {
        if (Constants.LINUX) {
            int rlimit_nproc = 6;
            JNACLibrary.Rlimit rlimit = new JNACLibrary.Rlimit();
            if (JNACLibrary.getrlimit(6, rlimit) == 0) {
                MAX_NUMBER_OF_THREADS = rlimit.rlim_cur.longValue();
            } else {
                logger.warn("unable to retrieve max number of threads [" + JNACLibrary.strerror(Native.getLastError()) + "]");
            }
        }
    }

    static void trySetMaxSizeVirtualMemory() {
        if (Constants.LINUX || Constants.MAC_OS_X) {
            JNACLibrary.Rlimit rlimit = new JNACLibrary.Rlimit();
            if (JNACLibrary.getrlimit(JNACLibrary.RLIMIT_AS, rlimit) == 0) {
                MAX_SIZE_VIRTUAL_MEMORY = rlimit.rlim_cur.longValue();
            } else {
                logger.warn("unable to retrieve max size virtual memory [" + JNACLibrary.strerror(Native.getLastError()) + "]");
            }
        }
    }

    static void trySetMaxFileSize() {
        if (Constants.LINUX || Constants.MAC_OS_X) {
            JNACLibrary.Rlimit rlimit = new JNACLibrary.Rlimit();
            if (JNACLibrary.getrlimit(JNACLibrary.RLIMIT_FSIZE, rlimit) == 0) {
                MAX_FILE_SIZE = rlimit.rlim_cur.longValue();
            } else {
                logger.warn("unable to retrieve max file size [" + JNACLibrary.strerror(Native.getLastError()) + "]");
            }
        }
    }

    static String rlimitToString(long value) {
        assert (Constants.LINUX || Constants.MAC_OS_X);
        if (value == JNACLibrary.RLIM_INFINITY) {
            return "unlimited";
        }
        return Long.toUnsignedString(value);
    }

    static boolean definitelyRunningAsRoot() {
        if (Constants.WINDOWS) {
            return false;
        }
        try {
            return JNACLibrary.geteuid() == 0;
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void tryVirtualLock() {
        JNAKernel32Library kernel = JNAKernel32Library.getInstance();
        Pointer process = null;
        try {
            process = kernel.GetCurrentProcess();
            JNAKernel32Library.SizeT size = new JNAKernel32Library.SizeT(JvmInfo.jvmInfo().getMem().getHeapInit().getBytes() + 0x100000L);
            if (!kernel.SetProcessWorkingSetSize(process, size, size)) {
                logger.warn("Unable to lock JVM memory. Failed to set working set size. Error code {}", (Object)Native.getLastError());
            } else {
                JNAKernel32Library.MemoryBasicInformation memInfo = new JNAKernel32Library.MemoryBasicInformation();
                long address = 0L;
                while (kernel.VirtualQueryEx(process, new Pointer(address), memInfo, memInfo.size()) != 0) {
                    boolean lockable;
                    boolean bl = lockable = memInfo.State.longValue() == 4096L && (memInfo.Protect.longValue() & 1L) != 1L && (memInfo.Protect.longValue() & 0x100L) != 256L;
                    if (lockable) {
                        kernel.VirtualLock(memInfo.BaseAddress, new JNAKernel32Library.SizeT(memInfo.RegionSize.longValue()));
                    }
                    address += memInfo.RegionSize.longValue();
                }
                LOCAL_MLOCKALL = true;
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
        }
        finally {
            if (process != null) {
                kernel.CloseHandle(process);
            }
        }
    }

    static String getShortPathName(String path) {
        assert (Constants.WINDOWS);
        try {
            WString longPath = new WString("\\\\?\\" + path);
            int length = JNAKernel32Library.getInstance().GetShortPathNameW(longPath, null, 0);
            if (length == 0) {
                logger.warn("failed to get short path name: {}", (Object)Native.getLastError());
                return path;
            }
            char[] shortPath = new char[length];
            if (JNAKernel32Library.getInstance().GetShortPathNameW(longPath, shortPath, length) > 0) {
                return Native.toString((char[])shortPath);
            }
            logger.warn("failed to get short path name: {}", (Object)Native.getLastError());
            return path;
        }
        catch (UnsatisfiedLinkError e) {
            return path;
        }
    }

    static void addConsoleCtrlHandler(ConsoleCtrlHandler handler) {
        if (Constants.WINDOWS) {
            try {
                boolean result = JNAKernel32Library.getInstance().addConsoleCtrlHandler(handler);
                if (result) {
                    logger.debug("console ctrl handler correctly set");
                } else {
                    logger.warn("unknown error {} when adding console ctrl handler", (Object)Native.getLastError());
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
    }

    static void tryInstallSystemCallFilter(Path tmpFile) {
        try {
            int ret = SystemCallFilter.init(tmpFile);
            LOCAL_SYSTEM_CALL_FILTER = true;
            if (ret == 1) {
                LOCAL_SYSTEM_CALL_FILTER_ALL = true;
            }
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                logger.debug("unable to install syscall filter", (Throwable)e);
            }
            logger.warn("unable to install syscall filter: ", (Throwable)e);
        }
    }
}

