/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.client.protocol;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.client.ReplicationFactor;
import org.apache.hadoop.hdds.client.ReplicationType;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ozone.OzoneAcl;
import org.apache.hadoop.ozone.client.BucketArgs;
import org.apache.hadoop.ozone.client.OzoneBucket;
import org.apache.hadoop.ozone.client.OzoneKey;
import org.apache.hadoop.ozone.client.OzoneKeyDetails;
import org.apache.hadoop.ozone.client.OzoneMultipartUploadList;
import org.apache.hadoop.ozone.client.OzoneMultipartUploadPartListParts;
import org.apache.hadoop.ozone.client.OzoneSnapshot;
import org.apache.hadoop.ozone.client.OzoneSnapshotDiff;
import org.apache.hadoop.ozone.client.OzoneVolume;
import org.apache.hadoop.ozone.client.TenantArgs;
import org.apache.hadoop.ozone.client.VolumeArgs;
import org.apache.hadoop.ozone.client.io.OzoneDataStreamOutput;
import org.apache.hadoop.ozone.client.io.OzoneInputStream;
import org.apache.hadoop.ozone.client.io.OzoneOutputStream;
import org.apache.hadoop.ozone.om.helpers.DeleteTenantState;
import org.apache.hadoop.ozone.om.helpers.OmKeyLocationInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartUploadCompleteInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatus;
import org.apache.hadoop.ozone.om.helpers.OzoneFileStatusLight;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.om.helpers.S3VolumeContext;
import org.apache.hadoop.ozone.om.helpers.TenantStateList;
import org.apache.hadoop.ozone.om.helpers.TenantUserInfoValue;
import org.apache.hadoop.ozone.om.helpers.TenantUserList;
import org.apache.hadoop.ozone.om.protocol.OzoneManagerProtocol;
import org.apache.hadoop.ozone.om.protocol.S3Auth;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.ozone.security.acl.OzoneObj;
import org.apache.hadoop.ozone.snapshot.CancelSnapshotDiffResponse;
import org.apache.hadoop.ozone.snapshot.SnapshotDiffResponse;
import org.apache.hadoop.security.KerberosInfo;
import org.apache.hadoop.security.token.Token;

@KerberosInfo(serverPrincipal="ozone.om.kerberos.principal")
public interface ClientProtocol {
    public List<OzoneManagerProtocolProtos.OMRoleInfo> getOmRoleInfos() throws IOException;

    public void createVolume(String var1) throws IOException;

    public void createVolume(String var1, VolumeArgs var2) throws IOException;

    public boolean setVolumeOwner(String var1, String var2) throws IOException;

    public void setVolumeQuota(String var1, long var2, long var4) throws IOException;

    public OzoneVolume getVolumeDetails(String var1) throws IOException;

    public S3VolumeContext getS3VolumeContext() throws IOException;

    public OzoneKey headS3Object(String var1, String var2) throws IOException;

    public OzoneKeyDetails getS3KeyDetails(String var1, String var2) throws IOException;

    public OzoneKeyDetails getS3KeyDetails(String var1, String var2, int var3) throws IOException;

    public OzoneVolume buildOzoneVolume(OmVolumeArgs var1);

    @Deprecated
    public boolean checkVolumeAccess(String var1, OzoneAcl var2) throws IOException;

    public void deleteVolume(String var1) throws IOException;

    public List<OzoneVolume> listVolumes(String var1, String var2, int var3) throws IOException;

    public List<OzoneVolume> listVolumes(String var1, String var2, String var3, int var4) throws IOException;

    public void createBucket(String var1, String var2) throws IOException;

    public void createBucket(String var1, String var2, BucketArgs var3) throws IOException;

    public void setBucketVersioning(String var1, String var2, Boolean var3) throws IOException;

    public void setBucketStorageType(String var1, String var2, StorageType var3) throws IOException;

    public void deleteBucket(String var1, String var2) throws IOException;

    @Deprecated
    public void checkBucketAccess(String var1, String var2) throws IOException;

    public OzoneBucket getBucketDetails(String var1, String var2) throws IOException;

    public List<OzoneBucket> listBuckets(String var1, String var2, String var3, int var4, boolean var5) throws IOException;

    @Deprecated
    public OzoneOutputStream createKey(String var1, String var2, String var3, long var4, ReplicationType var6, ReplicationFactor var7, Map<String, String> var8) throws IOException;

    public OzoneOutputStream createKey(String var1, String var2, String var3, long var4, ReplicationConfig var6, Map<String, String> var7) throws IOException;

    public OzoneDataStreamOutput createStreamKey(String var1, String var2, String var3, long var4, ReplicationConfig var6, Map<String, String> var7) throws IOException;

    public OzoneInputStream getKey(String var1, String var2, String var3) throws IOException;

    public void deleteKey(String var1, String var2, String var3, boolean var4) throws IOException;

    public void deleteKeys(String var1, String var2, List<String> var3) throws IOException;

    public void renameKey(String var1, String var2, String var3, String var4) throws IOException;

    @Deprecated
    public void renameKeys(String var1, String var2, Map<String, String> var3) throws IOException;

    public List<OzoneKey> listKeys(String var1, String var2, String var3, String var4, int var5) throws IOException;

    public List<RepeatedOmKeyInfo> listTrash(String var1, String var2, String var3, String var4, int var5) throws IOException;

    public boolean recoverTrash(String var1, String var2, String var3, String var4) throws IOException;

    public OzoneKeyDetails getKeyDetails(String var1, String var2, String var3) throws IOException;

    public void close() throws IOException;

    @Deprecated
    public OmMultipartInfo initiateMultipartUpload(String var1, String var2, String var3, ReplicationType var4, ReplicationFactor var5) throws IOException;

    public OmMultipartInfo initiateMultipartUpload(String var1, String var2, String var3, ReplicationConfig var4) throws IOException;

    public OzoneOutputStream createMultipartKey(String var1, String var2, String var3, long var4, int var6, String var7) throws IOException;

    public OzoneDataStreamOutput createMultipartStreamKey(String var1, String var2, String var3, long var4, int var6, String var7) throws IOException;

    public OmMultipartUploadCompleteInfo completeMultipartUpload(String var1, String var2, String var3, String var4, Map<Integer, String> var5) throws IOException;

    public void abortMultipartUpload(String var1, String var2, String var3, String var4) throws IOException;

    public OzoneMultipartUploadPartListParts listParts(String var1, String var2, String var3, String var4, int var5, int var6) throws IOException;

    public OzoneMultipartUploadList listMultipartUploads(String var1, String var2, String var3) throws IOException;

    public Token<OzoneTokenIdentifier> getDelegationToken(Text var1) throws IOException;

    public long renewDelegationToken(Token<OzoneTokenIdentifier> var1) throws IOException;

    public void cancelDelegationToken(Token<OzoneTokenIdentifier> var1) throws IOException;

    @Nonnull
    public S3SecretValue getS3Secret(String var1) throws IOException;

    public S3SecretValue getS3Secret(String var1, boolean var2) throws IOException;

    public S3SecretValue setS3Secret(String var1, String var2) throws IOException;

    public void revokeS3Secret(String var1) throws IOException;

    public void createTenant(String var1) throws IOException;

    public void createTenant(String var1, TenantArgs var2) throws IOException;

    public DeleteTenantState deleteTenant(String var1) throws IOException;

    public S3SecretValue tenantAssignUserAccessId(String var1, String var2, String var3) throws IOException;

    public void tenantRevokeUserAccessId(String var1) throws IOException;

    public void tenantAssignAdmin(String var1, String var2, boolean var3) throws IOException;

    public void tenantRevokeAdmin(String var1, String var2) throws IOException;

    public TenantUserInfoValue tenantGetUserInfo(String var1) throws IOException;

    public TenantUserList listUsersInTenant(String var1, String var2) throws IOException;

    public TenantStateList listTenant() throws IOException;

    public KeyProvider getKeyProvider() throws IOException;

    public URI getKeyProviderUri() throws IOException;

    public String getCanonicalServiceName();

    public OzoneFileStatus getOzoneFileStatus(String var1, String var2, String var3) throws IOException;

    public void createDirectory(String var1, String var2, String var3) throws IOException;

    public OzoneInputStream readFile(String var1, String var2, String var3) throws IOException;

    @Deprecated
    public OzoneOutputStream createFile(String var1, String var2, String var3, long var4, ReplicationType var6, ReplicationFactor var7, boolean var8, boolean var9) throws IOException;

    public OzoneOutputStream createFile(String var1, String var2, String var3, long var4, ReplicationConfig var6, boolean var7, boolean var8) throws IOException;

    public OzoneDataStreamOutput createStreamFile(String var1, String var2, String var3, long var4, ReplicationConfig var6, boolean var7, boolean var8) throws IOException;

    public List<OzoneFileStatus> listStatus(String var1, String var2, String var3, boolean var4, String var5, long var6) throws IOException;

    public List<OzoneFileStatus> listStatus(String var1, String var2, String var3, boolean var4, String var5, long var6, boolean var8) throws IOException;

    public List<OzoneFileStatusLight> listStatusLight(String var1, String var2, String var3, boolean var4, String var5, long var6, boolean var8) throws IOException;

    public boolean addAcl(OzoneObj var1, OzoneAcl var2) throws IOException;

    public boolean removeAcl(OzoneObj var1, OzoneAcl var2) throws IOException;

    public boolean setAcl(OzoneObj var1, List<OzoneAcl> var2) throws IOException;

    public List<OzoneAcl> getAcl(OzoneObj var1) throws IOException;

    public OzoneManagerProtocol getOzoneManagerClient();

    public void setBucketQuota(String var1, String var2, long var3, long var5) throws IOException;

    public void setReplicationConfig(String var1, String var2, ReplicationConfig var3) throws IOException;

    public OzoneKey headObject(String var1, String var2, String var3) throws IOException;

    public void setThreadLocalS3Auth(S3Auth var1);

    public void setIsS3Request(boolean var1);

    public S3Auth getThreadLocalS3Auth();

    public void clearThreadLocalS3Auth();

    default public ThreadLocal<S3Auth> getS3CredentialsProvider() {
        return null;
    }

    public boolean setBucketOwner(String var1, String var2, String var3) throws IOException;

    public Map<OmKeyLocationInfo, Map<DatanodeDetails, OzoneInputStream>> getKeysEveryReplicas(String var1, String var2, String var3) throws IOException;

    public String createSnapshot(String var1, String var2, String var3) throws IOException;

    public void deleteSnapshot(String var1, String var2, String var3) throws IOException;

    public OzoneSnapshot getSnapshotInfo(String var1, String var2, String var3) throws IOException;

    public String printCompactionLogDag(String var1, String var2) throws IOException;

    public List<OzoneSnapshot> listSnapshot(String var1, String var2, String var3, String var4, int var5) throws IOException;

    public SnapshotDiffResponse snapshotDiff(String var1, String var2, String var3, String var4, String var5, int var6, boolean var7, boolean var8) throws IOException;

    public CancelSnapshotDiffResponse cancelSnapshotDiff(String var1, String var2, String var3, String var4) throws IOException;

    public List<OzoneSnapshotDiff> listSnapshotDiffJobs(String var1, String var2, String var3, boolean var4) throws IOException;

    public void setTimes(OzoneObj var1, String var2, long var3, long var5) throws IOException;
}

