/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.common.statemachine;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.ozone.common.statemachine.InvalidStateTransitionException;

public class StateMachine<STATE extends Enum<?>, EVENT extends Enum<?>> {
    private STATE initialState;
    private Set<STATE> finalStates;
    private final LoadingCache<EVENT, Map<STATE, STATE>> transitions = CacheBuilder.newBuilder().build(CacheLoader.from(() -> new HashMap()));

    public StateMachine(STATE initState, Set<STATE> finalStates) {
        this.initialState = initState;
        this.finalStates = finalStates;
    }

    public STATE getInitialState() {
        return this.initialState;
    }

    public Set<STATE> getFinalStates() {
        return this.finalStates;
    }

    public STATE getNextState(STATE from, EVENT e) throws InvalidStateTransitionException {
        Enum target = (Enum)((Map)this.transitions.getUnchecked(e)).get(from);
        if (target == null) {
            throw new InvalidStateTransitionException((Enum<?>)from, (Enum<?>)e);
        }
        return (STATE)target;
    }

    public void addTransition(STATE from, STATE to, EVENT e) {
        ((Map)this.transitions.getUnchecked(e)).put(from, to);
    }
}

