/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.net;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.scm.net.NetworkTopology;
import org.apache.hadoop.hdds.scm.net.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NetUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NetUtils.class);
    private static final Pattern TRAILING_PATH_SEPARATOR = Pattern.compile("/+$");

    private NetUtils() {
    }

    public static String normalize(String path) {
        if (path == null) {
            return "";
        }
        int len = path.length();
        if (len == 0) {
            return "";
        }
        if (path.charAt(0) != '/') {
            throw new IllegalArgumentException("Network Location path does not start with /: " + path);
        }
        return len == 1 ? path : StringUtils.removeEnd((String)path, (String)"/");
    }

    public static int locationToDepth(String location) {
        String newLocation = NetUtils.normalize(location);
        return newLocation.equals("/") ? 1 : newLocation.split("/").length;
    }

    public static void removeDuplicate(NetworkTopology topology, Collection<Node> mutableExcludedNodes, List<String> mutableExcludedScopes, int ancestorGen) {
        if (CollectionUtils.isEmpty(mutableExcludedNodes) || CollectionUtils.isEmpty(mutableExcludedScopes) || topology == null) {
            return;
        }
        Iterator<Node> iterator = mutableExcludedNodes.iterator();
        while (iterator.hasNext() && !mutableExcludedScopes.isEmpty()) {
            Node node = iterator.next();
            Node ancestor = topology.getAncestor(node, ancestorGen);
            if (ancestor == null) {
                LOG.warn("Fail to get ancestor generation {} of node :{}", (Object)ancestorGen, (Object)node);
                continue;
            }
            mutableExcludedScopes.removeIf(ancestor::isAncestor);
            for (String scope : mutableExcludedScopes) {
                if (!ancestor.isDescendant(scope)) continue;
                iterator.remove();
            }
        }
    }

    public static List<Node> getAncestorList(NetworkTopology topology, Collection<Node> nodes, int generation) {
        ArrayList<Node> ancestorList = new ArrayList<Node>();
        if (topology == null || CollectionUtils.isEmpty(nodes) || generation == 0) {
            return ancestorList;
        }
        for (Node node : nodes) {
            Node ancestor = topology.getAncestor(node, generation);
            if (ancestor == null) {
                LOG.warn("Fail to get ancestor generation {} of node :{}", (Object)generation, (Object)node);
                continue;
            }
            if (ancestorList.contains(ancestor)) continue;
            ancestorList.add(ancestor);
        }
        return ancestorList;
    }

    public static String addSuffix(String path) {
        if (path == null) {
            return null;
        }
        if (!path.endsWith("/")) {
            return path + "/";
        }
        return path;
    }
}

