/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.container.common.helpers;

import org.apache.hadoop.hdds.client.ContainerBlockID;
import org.apache.hadoop.hdds.scm.pipeline.Pipeline;

public final class AllocatedBlock {
    private Pipeline pipeline;
    private ContainerBlockID containerBlockID;

    private AllocatedBlock(Pipeline pipeline, ContainerBlockID containerBlockID) {
        this.pipeline = pipeline;
        this.containerBlockID = containerBlockID;
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public ContainerBlockID getBlockID() {
        return this.containerBlockID;
    }

    public static class Builder {
        private Pipeline pipeline;
        private ContainerBlockID containerBlockID;

        public Builder setPipeline(Pipeline p) {
            this.pipeline = p;
            return this;
        }

        public Builder setContainerBlockID(ContainerBlockID blockId) {
            this.containerBlockID = blockId;
            return this;
        }

        public AllocatedBlock build() {
            return new AllocatedBlock(this.pipeline, this.containerBlockID);
        }
    }
}

