/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc.$internal.airlift.concurrent;

import io.prestosql.jdbc.;
import io.prestosql.jdbc.$internal.airlift.log.Logger;
import io.prestosql.jdbc.$internal.guava.base.Preconditions;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

@.ThreadSafe
public class BoundedExecutor
implements Executor {
    private static final Logger log = Logger.get(BoundedExecutor.class);
    private final Queue<Runnable> queue = new ConcurrentLinkedQueue<Runnable>();
    private final AtomicInteger queueSize = new AtomicInteger(0);
    private final AtomicBoolean failed = new AtomicBoolean();
    private final Executor coreExecutor;
    private final int maxThreads;

    public BoundedExecutor(Executor coreExecutor, int maxThreads) {
        Objects.requireNonNull(coreExecutor, "coreExecutor is null");
        Preconditions.checkArgument(maxThreads > 0, "maxThreads must be greater than zero");
        this.coreExecutor = coreExecutor;
        this.maxThreads = maxThreads;
    }

    @Override
    public void execute(Runnable task) {
        Preconditions.checkState(!this.failed.get(), "BoundedExecutor is in a failed state");
        this.queue.add(task);
        int size = this.queueSize.incrementAndGet();
        if (size <= this.maxThreads) {
            try {
                this.coreExecutor.execute(this::drainQueue);
            }
            catch (Throwable e) {
                this.failed.set(true);
                log.error("BoundedExecutor state corrupted due to underlying executor failure");
                throw e;
            }
        }
    }

    private void drainQueue() {
        do {
            try {
                this.queue.poll().run();
            }
            catch (Throwable e) {
                log.error(e, "Task failed");
            }
        } while (this.queueSize.getAndDecrement() > this.maxThreads);
    }
}

