/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.multitenant;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.ozone.om.multitenant.AccessPolicy;
import org.apache.hadoop.ozone.om.multitenant.OzoneTenantRolePrincipal;
import org.apache.hadoop.ozone.security.acl.IAccessAuthorizer;
import org.apache.hadoop.ozone.security.acl.OzoneObj;

public class RangerAccessPolicy
implements AccessPolicy {
    private OzoneObj accessObject;
    private final Map<String, List<AccessPolicy.AccessPolicyElem>> policyMap = new ConcurrentHashMap<String, List<AccessPolicy.AccessPolicyElem>>();
    private final HashSet<String> roleList;
    private String policyID;
    private String policyJsonString;
    private String policyName;
    private long lastPolicyUpdateTimeEpochMillis;

    public RangerAccessPolicy(String name) {
        this.policyName = name;
        this.roleList = new HashSet();
    }

    @Override
    public void setPolicyName(String id) {
        this.policyID = id;
    }

    @Override
    public String getPolicyID() {
        return this.policyID;
    }

    @Override
    public String getPolicyName() {
        return this.policyName;
    }

    @Override
    public HashSet<String> getRoleList() {
        return this.roleList;
    }

    @Override
    public void setPolicyLastUpdateTime(long mtime) {
        this.lastPolicyUpdateTimeEpochMillis = mtime;
    }

    @Override
    public long getPolicyLastUpdateTime() {
        return this.lastPolicyUpdateTimeEpochMillis;
    }

    @Override
    public String serializePolicyToJsonString() throws IOException {
        this.updatePolicyJsonString();
        return this.policyJsonString;
    }

    @Override
    public String deserializePolicyFromJsonString(JsonObject jsonObject) {
        this.setPolicyName(jsonObject.get("id").getAsString());
        try {
            JsonArray policyItems = jsonObject.getAsJsonArray("policyItems");
            for (int j = 0; j < policyItems.size(); ++j) {
                JsonObject policy = policyItems.get(j).getAsJsonObject();
                JsonArray roles = policy.getAsJsonArray("roles");
                for (int k = 0; k < roles.size(); ++k) {
                    if (this.roleList.contains(roles.get(k).getAsString())) continue;
                    this.roleList.add(roles.get(k).getAsString());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.setPolicyLastUpdateTime(jsonObject.get("updateTime").getAsLong());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public AccessPolicy.AccessPolicyType getAccessPolicyType() {
        return AccessPolicy.AccessPolicyType.RANGER_POLICY;
    }

    @Override
    public void addAccessPolicyElem(OzoneObj object, Principal principal, IAccessAuthorizer.ACLType acl, AccessPolicy.AccessGrantType grant) throws IOException {
        if (this.accessObject == null) {
            this.accessObject = object;
        } else if (!object.toString().equals(this.accessObject.toString())) {
            throw new IOException("RangerAccessPolicy supports only one object per policy");
        }
        AccessPolicy.AccessPolicyElem elem = new AccessPolicy.AccessPolicyElem(object, principal, acl, grant);
        if (!this.policyMap.containsKey(principal.getName())) {
            ArrayList<AccessPolicy.AccessPolicyElem> elemList = new ArrayList<AccessPolicy.AccessPolicyElem>();
            elemList.add(elem);
            this.policyMap.put(principal.getName(), elemList);
            return;
        }
        List<AccessPolicy.AccessPolicyElem> elemList = this.policyMap.get(principal.getName());
        for (AccessPolicy.AccessPolicyElem e : elemList) {
            if (e.getAclType() != acl) continue;
            throw new IOException("RangerAccessPolicy: Principal " + principal.getName() + " already exists with access " + (Object)((Object)acl));
        }
        elemList.add(elem);
    }

    @Override
    public List<AccessPolicy.AccessPolicyElem> getAccessPolicyElem() {
        ArrayList<AccessPolicy.AccessPolicyElem> list = new ArrayList<AccessPolicy.AccessPolicyElem>();
        for (Map.Entry<String, List<AccessPolicy.AccessPolicyElem>> entry : this.policyMap.entrySet()) {
            list.addAll((Collection<AccessPolicy.AccessPolicyElem>)entry.getValue());
        }
        return list;
    }

    @Override
    public void removeAccessPolicyElem(OzoneObj object, Principal principal, IAccessAuthorizer.ACLType acl, AccessPolicy.AccessGrantType grant) throws IOException {
        if (this.accessObject == null) {
            throw new IOException("removeAccessPolicyElem: Invalid Arguments.");
        }
        if (!object.toString().equals(this.accessObject.toString())) {
            throw new IOException("removeAccessPolicyElem:  Object not found." + object.toString());
        }
        if (!this.policyMap.containsKey(principal.getName())) {
            throw new IOException("removeAccessPolicyElem:  Principal not found." + object.toString());
        }
        List<AccessPolicy.AccessPolicyElem> elemList = this.policyMap.get(principal.getName());
        for (AccessPolicy.AccessPolicyElem e : elemList) {
            if (e.getAclType() != acl) continue;
            elemList.remove(e);
        }
        if (elemList.isEmpty()) {
            this.policyMap.remove(principal.toString());
        }
        throw new IOException("removeAccessPolicyElem:  aclType not found." + object.toString());
    }

    private String createRangerResourceItems() {
        StringBuilder resourceItems = new StringBuilder();
        resourceItems.append("\"resources\":{\"volume\":{\"values\":[\"");
        resourceItems.append(this.accessObject.getVolumeName());
        resourceItems.append("\"],\"isRecursive\":false,\"isExcludes\":false}");
        if (this.accessObject.getResourceType() == OzoneObj.ResourceType.BUCKET || this.accessObject.getResourceType() == OzoneObj.ResourceType.KEY) {
            resourceItems.append(",\"bucket\":{\"values\":[\"");
            resourceItems.append(this.accessObject.getBucketName());
            resourceItems.append("\"],\"isRecursive\":false,\"isExcludes\":false}");
        }
        if (this.accessObject.getResourceType() == OzoneObj.ResourceType.KEY) {
            resourceItems.append(",\"key\":{\"values\":[\"");
            resourceItems.append(this.accessObject.getKeyName());
            resourceItems.append("\"],\"isRecursive\":true,\"isExcludes\":false}");
        }
        resourceItems.append("},");
        return resourceItems.toString();
    }

    private String createRangerPolicyItems() throws IOException {
        StringBuilder policyItems = new StringBuilder();
        policyItems.append("\"policyItems\":[");
        int mapRemainingSize = this.policyMap.size();
        for (Map.Entry<String, List<AccessPolicy.AccessPolicyElem>> mapElem : this.policyMap.entrySet()) {
            --mapRemainingSize;
            List<AccessPolicy.AccessPolicyElem> list = mapElem.getValue();
            if (list.isEmpty()) continue;
            policyItems.append("{");
            if (list.get(0).getPrincipal() instanceof OzoneTenantRolePrincipal) {
                policyItems.append("\"roles\":[\"" + mapElem.getKey() + "\"],");
            } else {
                policyItems.append("\"users\":[\"" + mapElem.getKey() + "\"],");
            }
            policyItems.append("\"accesses\":[");
            Iterator<AccessPolicy.AccessPolicyElem> iter = list.iterator();
            while (iter.hasNext()) {
                AccessPolicy.AccessPolicyElem elem = iter.next();
                policyItems.append("{");
                policyItems.append("\"type\":\"");
                policyItems.append(this.getRangerAclString(elem.getAclType()));
                policyItems.append("\",");
                if (elem.getAccessGrantType() == AccessPolicy.AccessGrantType.ALLOW) {
                    policyItems.append("\"isAllowed\":true");
                } else {
                    policyItems.append("\"isDenied\":true");
                }
                policyItems.append("}");
                if (!iter.hasNext()) continue;
                policyItems.append(",");
            }
            policyItems.append("]");
            policyItems.append("}");
            if (mapRemainingSize <= 0) continue;
            policyItems.append(",");
        }
        policyItems.append("],");
        return policyItems.toString();
    }

    private String getRangerAclString(IAccessAuthorizer.ACLType aclType) throws IOException {
        switch (aclType) {
            case ALL: {
                return "All";
            }
            case LIST: {
                return "List";
            }
            case READ: {
                return "Read";
            }
            case WRITE: {
                return "Write";
            }
            case CREATE: {
                return "Create";
            }
            case DELETE: {
                return "Delete";
            }
            case READ_ACL: {
                return "Read_ACL";
            }
            case WRITE_ACL: {
                return "Write_ACL";
            }
            case NONE: {
                return "";
            }
        }
        throw new IOException("Unknown ACLType");
    }

    private void updatePolicyJsonString() throws IOException {
        this.policyJsonString = "{\"policyType\":\"0\",\"name\":\"" + this.policyName + "\",\"isEnabled\":true,\"policyPriority\":0,\"description\":\"Policy created by Ozone for Multi-Tenancy\",\"policyLabels\":[\"" + "OzoneTenant" + "\"],\"description\":\"\",\"isAuditEnabled\":true," + this.createRangerResourceItems() + "\"isDenyAllElse\":false," + this.createRangerPolicyItems() + "\"allowExceptions\":[],\"denyPolicyItems\":[],\"denyExceptions\":[],\"service\":\"cm_ozone\"}";
    }

    public String toString() {
        return "RangerAccessPolicy{accessObject=" + this.accessObject + ", policyMap=" + this.policyMap + ", roleList=" + this.roleList + ", policyID='" + this.policyID + '\'' + ", policyJsonString='" + this.policyJsonString + '\'' + ", policyName='" + this.policyName + '\'' + ", lastPolicyUpdateTimeEpochMillis=" + this.lastPolicyUpdateTimeEpochMillis + '}';
    }
}

