/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import com.google.protobuf.MessageLite;
import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.DelegatedCodec;
import org.apache.hadoop.hdds.utils.db.Proto2Codec;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public final class OmDBUserPrincipalInfo {
    private static final Codec<OmDBUserPrincipalInfo> CODEC = new DelegatedCodec(Proto2Codec.get((MessageLite)OzoneManagerProtocolProtos.TenantUserPrincipalInfo.getDefaultInstance()), OmDBUserPrincipalInfo::getFromProtobuf, OmDBUserPrincipalInfo::getProtobuf);
    private final Set<String> accessIds;

    public static Codec<OmDBUserPrincipalInfo> getCodec() {
        return CODEC;
    }

    public OmDBUserPrincipalInfo(Set<String> accessIds) {
        this.accessIds = new HashSet<String>(accessIds);
    }

    public Set<String> getAccessIds() {
        return this.accessIds;
    }

    public boolean addAccessId(String accessId) {
        return this.accessIds.add(accessId);
    }

    public boolean removeAccessId(String accessId) {
        return this.accessIds.remove(accessId);
    }

    public boolean hasAccessId(String accessId) {
        return this.accessIds.contains(accessId);
    }

    public OzoneManagerProtocolProtos.TenantUserPrincipalInfo getProtobuf() {
        return OzoneManagerProtocolProtos.TenantUserPrincipalInfo.newBuilder().addAllAccessIds(this.accessIds).build();
    }

    public static OmDBUserPrincipalInfo getFromProtobuf(OzoneManagerProtocolProtos.TenantUserPrincipalInfo proto) {
        return new Builder().setAccessIds(new HashSet<String>(proto.getAccessIdsList())).build();
    }

    public static final class Builder {
        private Set<String> accessIds;

        public Builder setAccessIds(Set<String> accessIds) {
            this.accessIds = accessIds;
            return this;
        }

        public OmDBUserPrincipalInfo build() {
            return new OmDBUserPrincipalInfo(this.accessIds);
        }
    }
}

