/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.helpers;

import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.hdds.client.DefaultReplicationConfig;
import org.apache.hadoop.hdds.protocol.StorageType;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.ozone.audit.Auditable;
import org.apache.hadoop.ozone.om.helpers.KeyValueUtil;
import org.apache.hadoop.ozone.om.helpers.WithMetadata;
import org.apache.hadoop.ozone.protocol.proto.OzoneManagerProtocolProtos;

public final class OmBucketArgs
extends WithMetadata
implements Auditable {
    private final String volumeName;
    private final String bucketName;
    private Boolean isVersionEnabled;
    private StorageType storageType;
    private long quotaInBytes = -1L;
    private long quotaInNamespace = -1L;
    private boolean quotaInBytesSet = false;
    private boolean quotaInNamespaceSet = false;
    private DefaultReplicationConfig defaultReplicationConfig = null;
    private String ownerName;

    private OmBucketArgs(String volumeName, String bucketName, Boolean isVersionEnabled, StorageType storageType, Map<String, String> metadata, String ownerName) {
        this.volumeName = volumeName;
        this.bucketName = bucketName;
        this.isVersionEnabled = isVersionEnabled;
        this.storageType = storageType;
        this.metadata = metadata;
        this.ownerName = ownerName;
    }

    public String getVolumeName() {
        return this.volumeName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public Boolean getIsVersionEnabled() {
        return this.isVersionEnabled;
    }

    public StorageType getStorageType() {
        return this.storageType;
    }

    public long getQuotaInBytes() {
        return this.quotaInBytes;
    }

    public boolean hasQuotaInBytes() {
        return this.quotaInBytesSet;
    }

    public long getQuotaInNamespace() {
        return this.quotaInNamespace;
    }

    public boolean hasQuotaInNamespace() {
        return this.quotaInNamespaceSet;
    }

    public DefaultReplicationConfig getDefaultReplicationConfig() {
        return this.defaultReplicationConfig;
    }

    private void setDefaultReplicationConfig(DefaultReplicationConfig defaultReplicationConfig) {
        this.defaultReplicationConfig = defaultReplicationConfig;
    }

    private void setQuotaInBytes(long quotaInBytes) {
        this.quotaInBytesSet = true;
        this.quotaInBytes = quotaInBytes;
    }

    private void setQuotaInNamespace(long quotaInNamespace) {
        this.quotaInNamespaceSet = true;
        this.quotaInNamespace = quotaInNamespace;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Map<String, String> toAuditMap() {
        LinkedHashMap<String, String> auditMap = new LinkedHashMap<String, String>();
        auditMap.put("volume", this.volumeName);
        auditMap.put("bucket", this.bucketName);
        auditMap.put("gdprEnabled", (String)this.metadata.get("gdprEnabled"));
        auditMap.put("isVersionEnabled", String.valueOf(this.isVersionEnabled));
        if (this.storageType != null) {
            auditMap.put("storageType", this.storageType.name());
        }
        if (this.ownerName != null) {
            auditMap.put("owner", this.ownerName);
        }
        return auditMap;
    }

    public OzoneManagerProtocolProtos.BucketArgs getProtobuf() {
        OzoneManagerProtocolProtos.BucketArgs.Builder builder = OzoneManagerProtocolProtos.BucketArgs.newBuilder();
        builder.setVolumeName(this.volumeName).setBucketName(this.bucketName);
        if (this.isVersionEnabled != null) {
            builder.setIsVersionEnabled(this.isVersionEnabled.booleanValue());
        }
        if (this.storageType != null) {
            builder.setStorageType(this.storageType.toProto());
        }
        if (this.quotaInBytesSet && (this.quotaInBytes > 0L || this.quotaInBytes == -1L)) {
            builder.setQuotaInBytes(this.quotaInBytes);
        }
        if (this.quotaInNamespaceSet && (this.quotaInNamespace > 0L || this.quotaInNamespace == -1L)) {
            builder.setQuotaInNamespace(this.quotaInNamespace);
        }
        if (this.defaultReplicationConfig != null) {
            builder.setDefaultReplicationConfig(this.defaultReplicationConfig.toProto());
        }
        if (this.ownerName != null) {
            builder.setOwnerName(this.ownerName);
        }
        return builder.build();
    }

    public static OmBucketArgs getFromProtobuf(OzoneManagerProtocolProtos.BucketArgs bucketArgs) {
        OmBucketArgs omBucketArgs = new OmBucketArgs(bucketArgs.getVolumeName(), bucketArgs.getBucketName(), bucketArgs.hasIsVersionEnabled() ? Boolean.valueOf(bucketArgs.getIsVersionEnabled()) : null, bucketArgs.hasStorageType() ? StorageType.valueOf(bucketArgs.getStorageType()) : null, KeyValueUtil.getFromProtobuf(bucketArgs.getMetadataList()), bucketArgs.hasOwnerName() ? bucketArgs.getOwnerName() : null);
        if (bucketArgs.hasDefaultReplicationConfig()) {
            omBucketArgs.setDefaultReplicationConfig(DefaultReplicationConfig.fromProto((HddsProtos.DefaultReplicationConfig)bucketArgs.getDefaultReplicationConfig()));
        }
        if (bucketArgs.hasQuotaInBytes()) {
            omBucketArgs.setQuotaInBytes(bucketArgs.getQuotaInBytes());
        }
        if (bucketArgs.hasQuotaInNamespace()) {
            omBucketArgs.setQuotaInNamespace(bucketArgs.getQuotaInNamespace());
        }
        return omBucketArgs;
    }

    public static class Builder {
        private String volumeName;
        private String bucketName;
        private Boolean isVersionEnabled;
        private StorageType storageType;
        private Map<String, String> metadata;
        private boolean quotaInBytesSet = false;
        private long quotaInBytes = -1L;
        private boolean quotaInNamespaceSet = false;
        private long quotaInNamespace = -1L;
        private DefaultReplicationConfig defaultReplicationConfig;
        private String ownerName;

        public Builder setVolumeName(String volume) {
            this.volumeName = volume;
            return this;
        }

        public Builder setBucketName(String bucket) {
            this.bucketName = bucket;
            return this;
        }

        public Builder setIsVersionEnabled(Boolean versionFlag) {
            this.isVersionEnabled = versionFlag;
            return this;
        }

        public Builder addMetadata(Map<String, String> metadataMap) {
            this.metadata = metadataMap;
            return this;
        }

        public Builder setStorageType(StorageType storage) {
            this.storageType = storage;
            return this;
        }

        public Builder setQuotaInBytes(long quota) {
            this.quotaInBytesSet = true;
            this.quotaInBytes = quota;
            return this;
        }

        public Builder setQuotaInNamespace(long quota) {
            this.quotaInNamespaceSet = true;
            this.quotaInNamespace = quota;
            return this;
        }

        public Builder setDefaultReplicationConfig(DefaultReplicationConfig defaultRepConfig) {
            this.defaultReplicationConfig = defaultRepConfig;
            return this;
        }

        public Builder setOwnerName(String owner) {
            this.ownerName = owner;
            return this;
        }

        public OmBucketArgs build() {
            Preconditions.checkNotNull((Object)this.volumeName);
            Preconditions.checkNotNull((Object)this.bucketName);
            OmBucketArgs omBucketArgs = new OmBucketArgs(this.volumeName, this.bucketName, this.isVersionEnabled, this.storageType, this.metadata, this.ownerName);
            omBucketArgs.setDefaultReplicationConfig(this.defaultReplicationConfig);
            if (this.quotaInBytesSet) {
                omBucketArgs.setQuotaInBytes(this.quotaInBytes);
            }
            if (this.quotaInNamespaceSet) {
                omBucketArgs.setQuotaInNamespace(this.quotaInNamespace);
            }
            return omBucketArgs;
        }
    }
}

