/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.ozone.om.S3SecretCache;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;

public class S3InMemoryCache
implements S3SecretCache {
    private final Cache<String, S3SecretValue> cache = CacheBuilder.newBuilder().build();

    @Override
    public void put(String id, S3SecretValue secretValue) {
        this.cache.put((Object)id, (Object)secretValue);
    }

    @Override
    public void invalidate(String id) {
        S3SecretValue secret = (S3SecretValue)this.cache.getIfPresent((Object)id);
        if (secret == null) {
            return;
        }
        secret.setDeleted(true);
        secret.setAwsSecret(null);
        this.cache.put((Object)id, (Object)secret);
    }

    @Override
    public void clearCache(List<Long> flushedTransactionIds) {
        HashMap<Long, String> transactionIdToCacheKeys = new HashMap<Long, String>();
        Set cacheKeys = this.cache.asMap().keySet();
        for (String cacheKey : cacheKeys) {
            S3SecretValue secretValue = (S3SecretValue)this.cache.getIfPresent((Object)cacheKey);
            if (secretValue == null) continue;
            transactionIdToCacheKeys.put(secretValue.getTransactionLogIndex(), cacheKey);
        }
        for (Long transactionId : flushedTransactionIds) {
            String cacheKey = (String)transactionIdToCacheKeys.get(transactionId);
            if (cacheKey == null) continue;
            this.cache.invalidate((Object)cacheKey);
        }
    }

    @Override
    public S3SecretValue get(String id) {
        return (S3SecretValue)this.cache.getIfPresent((Object)id);
    }
}

