/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.expression;

import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.type.Type;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Variable
extends ConnectorExpression {
    private final String name;

    public Variable(String name, Type type) {
        super(type);
        this.name = Objects.requireNonNull(name, "name is null");
        if (name.isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public List<? extends ConnectorExpression> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.getType());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Variable that = (Variable)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.getType(), that.getType());
    }

    @Override
    public String toString() {
        return this.name + "::" + String.valueOf(this.getType());
    }
}

